// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_GALLERY_H
#define TAPIOCA_GALLERY_H

#include <gtkmm.h>
#include <string>
#include <list>
#include "item.h"

#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/list.hpp>

namespace Tapioca
{
class Document;
class Gallery: public std::list<Document*>, public Item
{
    public:

	//! Copy constructor.
        Gallery(const Gallery& gallery);

	//! Create an empty gallery.
	Gallery();

	//! Destructor.
        virtual ~Gallery();

        // Set Methods
        
        void set_thumbnail(std::string id) {document_thumbnail_id = id;}


        void set_document_order(Document *document, Document *after);


        void remove_document(Document *document);

        void update_thumbnails();

        void find_deleted_documents(std::list<Document *> &removed);

        void add_document(Document *document);

        //Get Methods

        Glib::RefPtr<Gdk::Pixbuf> get_thumbnail_image() const;
        std::string get_thumbnail_id() const {return document_thumbnail_id;}

        //operators
        bool operator==(const Gallery &other)
          {
            return id == other.id && 
              latitude == other.latitude &&
              longitude == other.longitude &&
              title == other.title &&
              description == other.description &&
              document_thumbnail_id == other.document_thumbnail_id &&
              order == other.order &&
              tags == other.tags;
          }
    protected:

    private:
        std::string document_thumbnail_id;

        std::string get_next_in_order_sequence(std::string seq);
        bool has_order(std::string o) const;

        friend class boost::serialization::access;
                             
        template<class Archive>
          void serialize(Archive & ar, const unsigned int version)
            {
              ar & id;
              ar & latitude;
              ar & longitude;
              ar & title;
              ar & description;
              ar & document_thumbnail_id;
              ar & order;
              ar & tags;
              ar & static_cast<std::list<Document*>&>(*this);
            }
};
}

#endif // TAPIOCA_GALLERY_H

