// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_ITEM_H
#define TAPIOCA_ITEM_H

#include <gtkmm.h>
#include <string>


namespace Tapioca
{
class Item
{
    public:

	//! Copy constructor.
        Item(const Item& gallery);

	//! Create an empty item.
	Item();

	//! Destructor.
        virtual ~Item();

        // Set Methods
        
        void set_id(std::string i) {id = i;};

        void set_lat_long(double lat, double lon) {latitude=lat;longitude=lon;}

        void set_title(std::string t) {title = t;}

        void set_description(std::string desc) {description = desc;}

        void set_order(std::string o) {order = o;}

        void add_tag(std::string tag);

        void update_tag(std::string oldvalue, std::string newvalue);

        void remove_tag(std::string tag);

        //Get Methods

        std::string get_id() const {return id;}
        void get_lat_long(double &lat, double &lon) const {lat=latitude;lon=longitude;}
        double get_latitude() const {return latitude;}
        double get_longitude () const {return longitude;}

        std::string get_title() const {return title;}

        std::string get_description() const {return description;}

        std::string get_order() const {return order;}

        std::list<std::string> get_tags() const {return tags;}

        bool has_tag(std::string tag) const;

    protected:

        std::string id;
        double latitude;
        double longitude;
        std::string title;
        std::string description;
        std::string order;
        std::list<std::string> tags;
};
}

#endif // TAPIOCA_ITEM_H

