// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "changed-gallery.h"
#include "changed-document.h"

using namespace Tapioca;

ChangedGallery::ChangedGallery(const Gallery orig, const Gallery dest)
{
  first = orig;
  second = dest;

  //drop the documents
  first.clear();
  second.clear();
}

ChangedGallery::~ChangedGallery()
{
}

Glib::ustring ChangedGallery::get_change_description() const
{
  return ChangedDocument::get_change_description_for_items(first, second);
}
