// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_PROFILE_H
#define TAPIOCA_PROFILE_H

#include <gtkmm.h>
#include <string>
#include <list>

#include "gallerylist.h"
#include "gallery.h"
#include "document.h"

#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
#include <boost/serialization/list.hpp>

namespace Tapioca 
{
class Profile: public GalleryList
{
    public:

	//! Copy constructor.
        Profile(const Profile& profile);

	//! Create an empty profile.
	Profile();

	//! Destructor.
        virtual ~Profile();

        // Set Methods
        
        void set_url(std::string h) {url = h;}

        void set_id (std::string i) {id = i;}

        void set_username(std::string u) {username= u;}

        void set_password(std::string p) {password = p;}

        //Get Methods

        std::string get_url() const {return url;}

        std::string get_id() const {return id;}

        std::string get_username() const {return username;}

        std::string get_password() const {return password;}

        void pull_galleries();
        void process_galleries(std::string data);
        void process_gallery_documents(Gallery *gallery, std::string data, std::list<std::string> &thumbnail_urls);
        sigc::signal<void, Gallery*> processed_gallery;
        sigc::signal<void, Gallery*, Document*> processed_document_for_gallery;
        sigc::signal<void, Document*> processed_thumbnail_for_document;
        void process_thumbnail(Document *document, const char *data, guint len);
        static Glib::ustring decode_xml(Glib::ustring data);
    protected:

    private:
        std::string url;
        std::string id;
        std::string username;
        std::string password;

        friend class boost::serialization::access;
                             
        template<class Archive>
          void serialize(Archive & ar, const unsigned int version)
            {
              ar & url;
              ar & id;
              ar & username;
              //ar & password; //don't save this.  always ask / use keyring.
              ar & static_cast<GalleryList&>(*this);
            }

        Gallery *process_gallery_chunk(std::string data) const;
        std::string extract_id(std::string data) const;
        std::list<std::string> extract_gallery_tags(std::string data) const;
        std::string extract_gallery_title(std::string data) const;
        std::string extract_gallery_description(std::string data) const;
        std::string extract_gallery_id(std::string data) const;
        std::string extract_gallery_priority(std::string data) const;
        void extract_gallery_lat_lon(std::string data, double &lat, double &lon) const;
        std::string extract_gallery_thumbnail_id(std::string data) const;

        Tapioca::Document* extract_document(std::string data) const;
        std::string extract_document_id(std::string data) const;
        std::string extract_document_order(std::string data) const;
        std::string extract_original_document_filename(std::string data) const;
        std::string extract_document_title(std::string data) const;
        std::string extract_document_description(std::string data) const;
        std::list<std::string> extract_document_tags(std::string data) const;
        void extract_document_lat_long(std::string data, double &lat, double &lon) const;

        std::string extract_thumbnail_url(std::string data) const;
    
        static void replace(Glib::ustring &data, const Glib::ustring src, const Glib::ustring dest);
};
}

#endif // TAPIOCA_PROFILE_H

