//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_PROGRESS_DIALOG_H
#define TAPIOCA_PROGRESS_DIALOG_H

#include <gtkmm.h>
#include <sigc++/sigc++.h>

class ProgressDialog
{
 public:
    ProgressDialog();
    ~ProgressDialog();

    void set_parent_window(Gtk::Window &parent);

    void push_back(sigc::connection conn) {connections.push_back(conn);}
    void disconnect();
    void run();
    void hide();
    Gtk::Dialog* get_widget() const {return dialog;}

    void set_text(Glib::ustring t) {label->set_text(t);}
    void pulse() {progressbar->pulse();}
    void progress(double p) {progressbar->set_fraction(p);progressbar->show();}
    sigc::signal<void> aborted;

 private:
    Gtk::Dialog* dialog;
    Gtk::ProgressBar *progressbar;
    Gtk::Label *label;
    std::list<sigc::connection> connections;

    void on_dialog_closed(int response);
};

#endif // TAPIOCA_PROGRESS_DIALOG_H
