// Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include "item.h"

using namespace Tapioca;

Item::Item(const Item& d)
: id(d.id), latitude(d.latitude), longitude(d.longitude), title(d.title), 
    description(d.description), order(d.order), tags(d.tags)
{
}

Item::Item()
: id(""), latitude(0.0), longitude(0.0), title(""), description(""), order("")
{
}

Item::~Item()
{
}

std::string Item::get_tags_as_string() const
{
  std::string t;
  for (std::list<std::string>::const_iterator i = tags.begin(); 
       i != tags.end(); i++)
    t += (*i) + " ";
  return t;
}
