//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#ifndef TAPIOCA_CHANGE_EDITOR_DIALOG_H
#define TAPIOCA_CHANGE_EDITOR_DIALOG_H

#include <gtkmm.h>
#include "session.h"

class ChangesEditorDialog: public Gtk::Dialog
{
 public:
    static ChangesEditorDialog* create(Tapioca::Session *session);
    ChangesEditorDialog(BaseObjectType* baseObject, 
                        const Glib::RefPtr<Gtk::Builder>& xml);
    
    virtual ~ChangesEditorDialog();

    Tapioca::SessionChanges get_reverted_changes() const {return reverts;}
    Tapioca::SessionChanges get_changes() const {return changes;}
    //signals
    sigc::signal<void, Tapioca::Document*> view_document;
 private:
    Tapioca::Session *session;
    Tapioca::SessionChanges changes;
    Tapioca::SessionChanges reverts;
    Gtk::Expander *modified_galleries_expander;
    Gtk::TreeView *modified_galleries_treeview;
    Gtk::Label *modified_galleries_label;
    Gtk::Expander *modified_documents_expander;
    Gtk::TreeView *modified_documents_treeview;
    Gtk::Label *modified_documents_label;
    Gtk::Expander *removed_galleries_expander;
    Gtk::TreeView *removed_galleries_treeview;
    Gtk::Label *removed_galleries_label;
    Gtk::Expander *added_galleries_expander;
    Gtk::TreeView *added_galleries_treeview;
    Gtk::Label *added_galleries_label;
    Gtk::Expander *removed_documents_expander;
    Gtk::TreeView *removed_documents_treeview;
    Gtk::Label *removed_documents_label;
    Gtk::Expander *added_documents_expander;
    Gtk::TreeView *added_documents_treeview;
    Gtk::Label *added_documents_label;
    Gtk::Button *accept_button;

    Gtk::Menu modified_galleries_context_menu;
    Gtk::Menu modified_documents_context_menu;
    Gtk::Menu removed_documents_context_menu;
    Gtk::Menu added_galleries_context_menu;
    Gtk::Menu removed_galleries_context_menu;
    Gtk::Menu added_documents_context_menu;

    class ModifiedGalleriesColumns: public Gtk::TreeModelColumnRecord {
  public:
      ModifiedGalleriesColumns()
	{add(image); add(desc); add(data);}
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Glib::ustring> desc;
      Gtk::TreeModelColumn<Tapioca::ChangedGallery*> data;
    };
    const ModifiedGalleriesColumns modified_galleries_columns;
    Glib::RefPtr<Gtk::ListStore> modified_galleries_list;

    class ModifiedDocumentsColumns: public Gtk::TreeModelColumnRecord {
  public:
      ModifiedDocumentsColumns()
	{add(image); add(desc); add(data);}
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Glib::ustring> desc;
      Gtk::TreeModelColumn<Tapioca::ChangedDocument*> data;
    };
    const ModifiedDocumentsColumns modified_documents_columns;
    Glib::RefPtr<Gtk::ListStore> modified_documents_list;

    class RemovedGalleriesColumns: public Gtk::TreeModelColumnRecord {
  public:
      RemovedGalleriesColumns()
	{add(image); add(desc); add(data);}
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Glib::ustring> desc;
      Gtk::TreeModelColumn<Tapioca::ChangedGallery*> data;
    };
    const RemovedGalleriesColumns removed_galleries_columns;
    Glib::RefPtr<Gtk::ListStore> removed_galleries_list;

    class AddedGalleriesColumns: public Gtk::TreeModelColumnRecord {
  public:
      AddedGalleriesColumns()
	{add(image); add(desc); add(data);}
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Glib::ustring> desc;
      Gtk::TreeModelColumn<Tapioca::ChangedGallery*> data;
    };
    const AddedGalleriesColumns added_galleries_columns;
    Glib::RefPtr<Gtk::ListStore> added_galleries_list;

    class RemovedDocumentsColumns: public Gtk::TreeModelColumnRecord {
  public:
      RemovedDocumentsColumns()
	{add(image); add(desc); add(data);}
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Glib::ustring> desc;
      Gtk::TreeModelColumn<Tapioca::ChangedDocument*> data;
    };
    const RemovedDocumentsColumns removed_documents_columns;
    Glib::RefPtr<Gtk::ListStore> removed_documents_list;

    class AddedDocumentsColumns: public Gtk::TreeModelColumnRecord {
  public:
      AddedDocumentsColumns()
	{add(image); add(desc); add(data);}
      Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > image;
      Gtk::TreeModelColumn<Glib::ustring> desc;
      Gtk::TreeModelColumn<Tapioca::ChangedDocument*> data;
    };
    const AddedDocumentsColumns added_documents_columns;
    Glib::RefPtr<Gtk::ListStore> added_documents_list;
    //callbacks
    void on_modified_gallery_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn *col);
    void on_modified_document_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn *col);
    void on_removed_gallery_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn *col);
    void on_added_gallery_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn *col);
    void on_removed_document_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn *col);
    void on_added_document_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn *col);
    void on_revert_modified_gallery();
    void on_revert_modified_document();
    void on_revert_removed_document();
    void on_revert_added_gallery();
    void on_revert_removed_gallery();
    void on_revert_added_document();
    void on_treeview_clicked(GdkEventButton *event, Gtk::Menu &context_menu);
    void on_dialog_loaded(Tapioca::Session *session);

    //helpers

    void fill_modified_galleries(std::list<Tapioca::ChangedGallery> &l);
    void fill_modified_documents(std::list<Tapioca::ChangedDocument> &l);
    void fill_removed_galleries(std::list<Tapioca::ChangedGallery> &l);
    void fill_added_galleries(std::list<Tapioca::ChangedGallery> &l);
    void fill_removed_documents(std::list<Tapioca::ChangedDocument> &l);
    void fill_added_documents(std::list<Tapioca::ChangedDocument> &l);

    void add_row_modified_gallery(Tapioca::ChangedGallery *gallery);
    void add_row_modified_document(Tapioca::ChangedDocument *document);
    void add_row_removed_gallery(Tapioca::ChangedGallery *gallery);
    void add_row_added_gallery(Tapioca::ChangedGallery *gallery);
    void add_row_removed_document(Tapioca::ChangedDocument *document);
    void add_row_added_document(Tapioca::ChangedDocument *document);

    void update_buttons();
    Tapioca::ChangedGallery* get_selected_modified_gallery() const;
    Tapioca::ChangedDocument* get_selected_modified_document() const;
    Tapioca::ChangedDocument* get_selected_removed_document() const;
    Tapioca::ChangedGallery * get_selected_added_gallery() const;
    Tapioca::ChangedGallery * get_selected_removed_gallery() const;
    Tapioca::ChangedDocument* get_selected_added_document() const;

    void remove_same_removed_document(Tapioca::ChangedDocument *document);
    void remove_same_added_document(Tapioca::ChangedDocument *document);
    void remove_documents_belonging_to_reverted_added_gallery(Tapioca::ChangedGallery *gallery);
    void remove_documents_belonging_to_reverted_removed_gallery(Tapioca::ChangedGallery *gallery);
    void remove_removed_parent_gallery(Tapioca::ChangedDocument *document);
    
    void update_selected_added_document_name();
    void update_selected_added_gallery_name();
    void update_selected_modified_document_changes();
    void update_selected_modified_gallery_changes();

};

#endif // TAPIOCA_PUBLISH_DIALOG_H
