-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "resources"
require "transforms"
require "widgets"
require "bookmarks"

local function callhooks (hooks, ...)
   if type (hooks) == "table" then
      for _, hook in pairs(hooks) do
         if ... and type(...) == "table" then
            hook (unpack(...))
         else
            hook (...)
         end
      end
   elseif type (hooks) == "function" then
      if ... and type(...) == "table" then
         hooks(unpack(...))
      else
         hooks (...)
      end
   end
end

aviation.crashed.airrace = function (...)
			      callhooks (airrace.crashed, ...)
			   end

airrace = {}

resources.dofile "airrace/gate.lua"
resources.dofile "airrace/tracksets.lua"
resources.dofile "airrace/httpd.lua"

-- Open the replay bookmarks.

network.replays = network.bookmark {
   path = os.getenv ("HOME") .. "/.airrace.d/replays"
}

-- Load per-user configuration.

local rcscript = loadfile (os.getenv ("HOME") .. "/.airrace")

if rcscript then
   print ("  " .. os.getenv ("HOME") .. "/.airrace")
   rcscript ()
end

-- Load user career.

local career = loadfile (os.getenv ("HOME") .. "/.airrace.d/career")

if career then
   print ("  " .. os.getenv ("HOME") .. "/.airrace.d/career")
   career ()
end

-- Start or wait for web interface.

if options.track then
   airrace.track = options.track

   resources.dofile "airrace/restart.lua"

   graphics.hide = false
   network.block = false
else
   graphics.hide = true
   network.block = true
end
