-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- The race-track setup.

local h = 450

aviation.initial = {units.meters {0, -1500, h}, units.knots (120), 45}
aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {142, 6}
aviation.turbidity = 2.5

airrace.sequence = {}
airrace.gates = {}

local phases = {0, 1, 2, 3, 4, 5, 6, 7, 8}

for i = 1, #phases do
   local omega = math.pi / 4 * phases[i]

   airrace.sequence[i] = i
   airrace.gates[i] = airrace.gate {
      rotation = math.deg(math.atan(math.cos(omega))),
      position = {phases[i] / 8 * 5000 + 500,
		  math.sin (omega) * 1000 - 1000,
		  h},
      width = 20,
      index = i,
   }
end
