-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local c, h = 200, 500

aviation.initial = {units.meters {-250, 2 * c, h}, units.knots (120), 0}
aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {142, 7}
aviation.turbidity = 3

-- The race-track setup.

airrace.sequence = {1, 2, 3, 4, 5, 2, 6, 7, 1}
airrace.gates = {
   airrace.gate {
      position = {c, 2 * c, h},
      width = 20,
   },

   airrace.quadgate {
      position = {4 * c, 0, h},
      rotation = 45,
      size = {25, 25},
   },

   airrace.gate {
      position = {7 * c, -2 * c, h},
      width = 20,
   },

   airrace.gate {
      position = {10 * c, 0, h},
      rotation = 90,
      width = 20,
   },

   airrace.gate {
      position = {7 * c, 2 * c, h},
      width = 20,
   },

   airrace.gate {
      position = {c, -2 * c, h},
      width = 20,
   },

   airrace.gate {
      position = {-2 * c, 0, h},
      rotation = 90,
      width = 20,
   },
}
