-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local h = 1200

aviation.initial = {units.meters {5000, 1000, h}, units.knots (180), -90}
aviation.latitudes = {2, 6}
aviation.longitudes = {2, 6}
aviation.time = {142, 18}
aviation.turbidity = 2

-- The race-track setup.

airrace.sequence = {1, 2, 3, 2}
airrace.gates = {
   airrace.gate {
      position = {4000, 0, h},
      width = 20,
      color = {1.5, 1.5, 1.6},
   },
   
   airrace.gate {
      position = {5000, 0, h},
      width = 20,
   },
   
   airrace.gate {
      position = {6000, 0, h},
      width = 20,
      color = {1.5, 1.5, 0.4},
   },
}
