-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"

print "\nLoading the http server pages."

network.mime["/stylesheet"] = "text/css"
network.pages["/stylesheet"] = resources.readfile "airrace/pages/stylesheet.lua"

network.mime["/logo"] = "image/svg+xml"
network.pages["/logo"] = resources.readfile "airrace/pages/logo.svg"

network.pages["/drawdiagram"] = resources.readfile "airrace/pages/drawdiagram.lua"
network.mime["/drawdiagram"] = "image/svg+xml"

network.pages["/"] = resources.readfile "airrace/pages/default.lua"
network.pages["/settings"] = resources.readfile "airrace/pages/settings.lua"
network.pages["/tracks"] = resources.readfile "airrace/pages/tracks.lua" 
network.pages["/briefing"] = resources.readfile "airrace/pages/briefing.lua" 
network.pages["/debriefing"] = resources.readfile "airrace/pages/debriefing.lua" 
network.pages["/race"] = resources.readfile "airrace/pages/race.lua" 
network.pages["/fly"] = resources.readfile "airrace/pages/fly.lua"
network.pages["/replay"] = resources.readfile "airrace/pages/replay.lua"
network.pages["/replays"] = resources.readfile "airrace/pages/replays.lua"

network.mime["/export"] = "application/x-lua"
network.pages["/export"] = resources.readfile "airrace/pages/export.lua"

network.pages["/setvalue"] = [[
<?lua
   local text = ""

   if query then
      for argument, value in pairs (query) do
	 assert(loadstring (tostring(argument) .. " = " .. tostring(value)))()
	 text = text .. tostring(argument) .. " set to " ..
                tostring(value) .. '\n'
      end
   end

   return text
?>
]]
   
network.mime["/finished"] = "text/plain"
network.pages["/finished"] = function (method, url, version)
				 if not airrace.running then
				    return "true"
				 end
			      end
