<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<?lua
   _ = {}
   _.trackset, _.track = string.match (airrace.track, "(.*)/track(%d*)%.lua")
 ?>

<head>
  <title>Race results</title>
  <link rel="stylesheet" href="stylesheet" />
  <style type="text/css">
  table.bordered {
      border:solid;
      border-width:thin;
      border-color:slategray;
  }

  th {
      text-align:center;
  }

  td {
      text-align:center;
  }

  th.left, td.left {
      text-align:left;
  }
  
  td.shaded, th.shaded {
      background-color:gainsboro;
  }

  th.top {
      background-color:slategray;
  }

  h2 {
      background-color:#b4cdcd;
  }
  
  h3 {
      background-color:gainsboro;
  }
  </style>
</head>

<body>
  <hr/> 

  <div class="logo-container">
    <div class="menu-container">
      <?lua
        if not airrace.saved then
	   return string.format ([[
      <a href="/fly?trackset=%s&track=%d">retry</a>
      &middot;
				 ]], _.trackset, _.track)
	end
       ?>
      <a href="/replay">replay</a>
      &middot;
      <a href="/export">export</a>
      &middot;
      <?lua
        if airrace.saved then
	   return [[
      <a href="/replays">back</a>
	   ]]
	else
	   return string.format ([[
      <a href="/replay?save=true">save</a>
      &middot;
      <a href="/briefing?trackset=%s&track=%d">back</a>
				 ]], _.trackset, _.track)

	end
       ?>
    </div>
  </div>

  <hr/>
 
  <h2>
    <hr/> 
    <?lua return airrace.headline ?>
    <hr/>
  </h2>

  <p>
    The table below lists elapsed time and average performace statistics
    for each section of the race flown by <?lua return airrace.headline ?>.

  <h3>
    <hr/> 
    Sections
    <hr/>
  </h3>

  <table class="bordered" style="width:100%">
    <col style="width:2em" />

    <tr>
      <th class="top"></th>
      <th class="top">Time</th>
      <th class="top" colspan=3>Velocity (mph)</th>
      <th class="top" colspan=2>Acceleration (G)</th>
      <th class="top" colspan=2>Angle of attack (deg)</th>
    </tr>

    <tr>
      <th class="shaded"></th>
      <th></th>
      <th class="shaded">min</th>
      <th>max</th>
      <th class="shaded">mean</th>
      <th>min</th>
      <th class="shaded">max</th>
      <th>min</th>
      <th class="shaded">max</th>
    </tr>

    <?lua
      local html = ""

      for i = 1, #airrace.sections do
	 html = html .. string.format([[

     <tr name="section">
       <td class="shaded">%d</td>
       <td>%.2f</td>
       <td class="shaded">%.1f</td>
       <td>%.1f</td>
       <td class="shaded">%.1f</td>
       <td>%.1f</td>
       <td class="shaded">%.1f</td>
       <td>%.1f</td>
       <td class="shaded">%.1f</td>
     </tr>]], i,
              airrace.sections[i][1],
              airrace.sections[i][2][1],
              airrace.sections[i][2][2],
              airrace.sections[i][2][3],
              airrace.sections[i][3][1],
              airrace.sections[i][3][2],
              airrace.sections[i][4][1],
              airrace.sections[i][4][2])
      end

      return html
     ?>
  </table>

  <h3>
    <hr/> 
    Notes
    <hr/>
  </h3>

  <div name="notes">
    <?lua
      local html = ""

      for i = 1, #airrace.notes do
	 html = html .. string.format([[

     <div>%s</div>]], airrace.notes[i]);
      end

      return html
     ?>
  </div>
</body>
