<?xml version="1.0" standalone="no"?>

<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" 
          "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">
  <?lua
         _ = {
	    margin = {0, 0, 0, 0},
	    scale = 10,
	    fontsize = 28,
	    stems = {},
	    inverted = {},
	    orientation = {1, -1},
	    flipped = {},
	    stretch = {},
	    lower = {1 / 0, 1 / 0},
	    upper = {-1 / 0, -1 / 0},
	    colors = {},
	 }
	 
         if query then
	    for key, value in pairs(query) do
	       if key == "track" then
		  resources.dofile (value)
	       else
		  assert(loadstring("_." .. tostring(key) ..
				 " = " .. tostring(value)))()
	       end
	    end
	 end

         for i, gate in pairs(airrace.gates) do
	    local x, y, s_x, s_y

	    x = _.portrait and gate.position[2] or gate.position[1]
	    y = _.portrait and gate.position[1] or gate.position[2]
	    s_x = _.orientation and _.orientation[1] or 1
	    s_y = _.orientation and _.orientation[2] or 1

	    _.lower[1] = _.lower[1] < s_x * x and _.lower[1] or s_x * x
	    _.lower[2] = _.lower[2] < s_y * y and _.lower[2] or s_y * y
	    _.upper[1] = _.upper[1] > s_x * x and _.upper[1] or s_x * x
	    _.upper[2] = _.upper[2] > s_y * y and _.upper[2] or s_y * y
	 end
	 
	 _.viewbox = {
	    _.lower[1] - _.margin[1], _.lower[2] - _.margin[3],
	    _.upper[1] - _.lower[1] + _.margin[1] + _.margin[2],
	    _.upper[2] - _.lower[2] + _.margin[3] + _.margin[4]
	 }

	 _.aspect = _.viewbox[3] / _.viewbox[4]
	 _.width = _.width or (_.height and _.aspect * _.height) or 800
	 _.height = _.height or _.width /_.aspect 
   ?>
	
  <svg <?lua
 	 return string.format([[width="%d" height="%d"
       viewBox="%f %f %f %f"]], _.width, _.height, unpack(_.viewbox))
        ?>

       xmlns="http://www.w3.org/2000/svg" version="1.1" 
       xmlns:xlink="http://www.w3.org/1999/xlink">

    <defs>
      <g id="pylon">
	<circle r="<?lua return tostring(2.5 * _.scale) ?>" stroke="black"/>
	<circle r="<?lua return tostring(1.8 * _.scale) ?>"
                fill="white" stroke="black"/>
	<circle r="<?lua return tostring(_.scale) ?>" stroke="black"/>
      </g>
    </defs>

    <?lua
	 local html = ""

	 html = html .. string.format([[
    <rect x="%f" y="%f" width="%f" height="%f" fill="#fffaf0" 
          stroke="black" style="stroke-dasharray: 9, 5"/>
			]], _.viewbox[1], _.viewbox[2],
			    _.viewbox[3], _.viewbox[4])

	 for i, gate in pairs (airrace.gates) do
	    local p, h_w, h_d, c, s, theta, phi
	    
	    c = _.scale
	    p = {gate.position[_.portrait and 2 or 1] * _.orientation[1],
		 gate.position[_.portrait and 1 or 2] * _.orientation[2],
	         gate.position[3]}
	    h_w = 0.5 * (_.stretch[i] or c) *
	          (gate.width or (gate.size and gate.size[2]))
	    h_d = ((gate.size and gate.size[1]) or 0) *
	          (_.stretch[i] or c) * 0.5

	    s = _.stems[i] and {_.stems[i][1] or 12,
				_.stems[i][2] or 4,
				math.rad(_.stems[i][3] or 45) + 
			        (_.flipped[i] and math.rad(90) or 0)}
	                   or {12, 4, _.flipped[i] and math.rad(135)
			                           or math.rad(45)}
	    phi = math.rad(gate.rotation)
	    theta = phi * (_.portrait and -1 or 1) *
	            _.orientation[1] * _.orientation[2] - 
	            (_.portrait and math.pi / 2 or 0) +
	            (_.inverted[i] and math.pi or 0)

	    html = html .. string.format([[
      <g transform="rotate(%f,%f,%f) translate(%f,%f)">
					 ]], math.deg(theta),
				             p[1], p[2],
					     p[1], p[2])

	    html = html .. string.format([[
         <polyline stroke="black" fill="none" style="stroke-dasharray: 9, 5"
                   points="%f,%f %f,%f %f,%f %f,%f"/>
				      ]], h_d, h_w, h_d, -h_w,
				          h_d, -h_w - s[1] * c,
					  h_d - s[2] * c * math.cos(s[3]),
					  -h_w - s[1] * c - s[2] * c * math.sin(s[3]))

	    if h_d > 0 then
	       html = html .. string.format([[
         <polyline stroke="black" fill="none" style="stroke-dasharray: 9, 5"
                   points="%f,%f %f,%f %f,%f %f,%f"/>
				      ]],h_d, h_w, -h_d, h_w,
					 -h_d, -h_w, h_d, -h_w)

	    end

	    html = html .. string.format([[
         <circle stroke="none" fill="black" cx="%f" cy="%f" r="%f"/>
      </g>
				      ]], h_d - s[2] * c * math.cos(s[3]),
					  -h_w - s[1] * c - s[2] * c * math.sin(s[3]),
					  0.5 * c)

	    html = html .. string.format([[
       <g transform="translate(%f,%f)">
         <text x="%f" y="%f" font-family="sans" font-size="%f">
	   <tspan style="font-weight:bold">%d:</tspan> %dm@%d&#176;
         </text>
       </g>
		   ]], p[1], p[2],
		       (h_w + s[1] * c) * math.sin(theta) +
		       h_d * math.cos(theta) -
                       s[2] * c * math.cos(s[3] + theta) +
		       0.05 * c * _.fontsize,
		       -(h_w + s[1] * c) * math.cos(theta) +
		       h_d * math.sin(theta) -
                       s[2] * c * math.sin(s[3] + theta) +
		       0.04 * c * _.fontsize,
		       _.fontsize, i, p[3],
		       phi > 0 and math.floor (math.deg(phi) + 0.5)
		               or math.ceil (math.deg(phi) - 0.5))
                       
	 end

	 -- Draw the pylons separately so they'll be
	 -- stacked on top of the line art.

	 for i, gate in pairs (airrace.gates) do
	    local p, c, h_w, h_d, phi, theta
	    
	    c = _.scale
	    l = _.colors[i] or "firebrick"
	    p = {gate.position[_.portrait and 2 or 1] * _.orientation[1],
		 gate.position[_.portrait and 1 or 2] * _.orientation[2],
	         gate.position[3]}
	    h_w = 0.5 * (_.stretch[i] or c) *
	          (gate.width or (gate.size and gate.size[2]))
	    h_d = ((gate.size and gate.size[1]) or 0) *
	          (_.stretch[i] or c) * 0.5
	    phi = math.rad(gate.rotation)
	    theta = phi * (_.portrait and -1 or 1) *
	            _.orientation[1] * _.orientation[2] - 
	            (_.portrait and math.pi / 2 or 0) +
	            (_.inverted[i] and math.pi or 0)

	    html = html .. string.format([[
      <g transform="rotate(%f,%f,%f)">
					 ]], math.deg(theta), p[1], p[2])

	    if tostring(gate) == "Halfgate" then
	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]],
				 p[1],
				 p[2] + (_.inverted[i] and h_w or -h_w),
				 l)
	    end

	    if tostring(gate) == "Airgate" then
	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]], p[1], p[2] + h_w, l)
	       
	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]], p[1], p[2] - h_w, l)
	    end


	    if tostring(gate) == "Quadgate" then
	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]], p[1] + h_d, p[2] + h_w, l)
	       
	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]], p[1] + h_d, p[2] - h_w, l)

	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]], p[1] - h_d, p[2] + h_w, l)
	       
	       html = html .. string.format([[
         <use x="%f" y="%f" xlink:href="#pylon" fill="%s"/>
	 				 ]], p[1] - h_d, p[2] - h_w, l)
	    end

	    html = html .. [[
        </g>	
	       ]]
	 end

	 return html
     ?>
</svg>
