<?lua
  -- Copyright (C) 2008 Papavasileiou Dimitris                             
  --                                                                      
  -- This program is free software: you can redistribute it and/or modify 
  -- it under the terms of the GNU General Public License as published by 
  -- the Free Software Foundation, either version 3 of the License, or    
  -- (at your option) any later version.                                  
  --                                                                      
  -- This program is distributed in the hope that it will be useful,      
  -- but WITHOUT ANY WARRANTY; without even the implied warranty of       
  -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
  -- GNU General Public License for more details.                         
  --                                                                      
  -- You should have received a copy of the GNU General Public License    
  -- along with this program.  If not, see <http://www.gnu.org/licenses/>.

    local blackbox, text, script, trackset, track, headline

    headline = airrace.headline
    trackset, track = string.match (airrace.track, "(.*)/track(%d*)%.lua")

    blackbox = aviation.nodes.plane.avionics.blackbox
    script = "{"

    for _, entry in ipairs (blackbox) do
       script = script .. string.format("{%g,%g,%g,%g},",
					unpack(entry))
    end
    
    script = script .. "}"

    text = string.format ([=[
if not airrace.running then
   airrace.saved = false
   airrace.headline = "%s"
   airrace.track = "%s/track%d.lua"
   resources.dofile "airrace/restart.lua"

   aviation.nodes.plane.avionics.script = %s

   graphics.hide = false
   network.block = false
end
                            ]=], headline, trackset, track, script)

    return text
?>
