<?lua
  -- Copyright (C) 2008 Papavasileiou Dimitris                             
  --                                                                      
  -- This program is free software: you can redistribute it and/or modify 
  -- it under the terms of the GNU General Public License as published by 
  -- the Free Software Foundation, either version 3 of the License, or    
  -- (at your option) any later version.                                  
  --                                                                      
  -- This program is distributed in the hope that it will be useful,      
  -- but WITHOUT ANY WARRANTY; without even the implied warranty of       
  -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
  -- GNU General Public License for more details.                         
  --                                                                      
  -- You should have received a copy of the GNU General Public License    
  -- along with this program.  If not, see <http://www.gnu.org/licenses/>.

  require "bookmarks"

  local blackbox, html, redirect, script, trackset, track, headline

  headline = airrace.headline
  trackset, track = string.match (airrace.track, "(.*)/track(%d*).lua")

  blackbox = aviation.nodes.plane.avionics.blackbox
  script = "{"

  for _, entry in ipairs (blackbox) do
     script = script .. string.format("{%g,%g,%g,%g},",
				      unpack(entry))
  end
    
  script = script .. "}"

  redirect = [[
<head></head>
<body onload="javascript:window.location = '/replays';"></body>
     ]]

  html = string.format ([[
<head>
  <title>%s</title>
</head>

<body onload="javascript:document.replay.submit();">
  <form name="replay" enctype="multipart/form-data"
        action="/fly" method="post">
     <input type="hidden"
            name="saved"
            value="%s"/>

     <input type="hidden"
            name="headline"
            value="%s"/>

     <input type="hidden"
            name="trackset"
            value="%s"/>

     <input type="hidden"
            name="track"
            value="%s"/>

     <input type="hidden"
            name="script"
            value="%s"/>
  </form>   
</body>
			  ]], headline, query.save and "true" or "false",
		              headline, trackset, track, script)

  if query.save then
     local uri

     uri = string.format("/replay-%s-%s-%d", trackset, track, os.time())

     network.replays.pages[uri] = html
     network.replays.tags[uri] = headline

     return redirect
  else
     return html
  end
?>
