<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Settings</title>
  <link rel="stylesheet" href="stylesheet">

  <script type="text/javascript">

    function init()
    {
       document.settings['options.fullscreen'][1].onclick = 
	  function ()
	  {
	     document.settings['derived.width'].disabled =
		document.settings['options.fullscreen'][1].checked;
	     document.settings['derived.height'].disabled =
		document.settings['options.fullscreen'][1].checked;       
	  }
    }

    function submit(save)
    {
       for (i = 0 ; i < document.settings.length ; i += 1) {
	  var element = document.settings.elements[i];

	  if (element.type == "checkbox" && element.checked) {
	     document.settings[element.name][0].disabled = "true";
	  }
       }

       if (document.settings['options.fullscreen'][1].checked) {
	  document.settings['derived.width'].disabled = false;
	  document.settings['derived.width'].value =
	     "<?lua return configuration.screen[1] ?>";

	  document.settings['derived.height'].disabled = false;
	  document.settings['derived.height'].value =
	     "<?lua return configuration.screen[2] ?>";
       }

       document.settings['save'].value = save;
       document.settings.submit();

       return true;
    }

  </script>
</head>

<body onLoad="init();">
  <hr/> 

  <div class="logo-container">
    <div class="menu-container">
      <a href="javascript:submit(false)">apply</a>
      &middot;
      <a href = "javascript:submit(true)">save</a>
      &middot;
      <a href = "/">back</a>
    </div>
  </div>

  <hr> 

  <p>
    Edit the following form and click apply to set physical
    parameters, system settings, etc.
  </p>
  
  <form name="settings" action="/settings"
        method="get" onsubmit="return validate();">
    <input type="hidden" name="save" value="false">
    <table>
      <col style="width:12em">
      <col style="width:7em">

      <?lua
      require "derived"

      local html = ""
      local groups = {
	 ["Graphics"] = {
	    {'derived.width', 'Width', 'The width of the window.'},
	    {'derived.height', 'Height', 'The height of the window.'},
	    {'options.fullscreen', 'Fullscreen mode',
	     'Hog all available screen real estate.',
	     false},
	    {'derived.field', 'Field of view', 'The field of view.'},
	    {'options.groundlod', 'Ground triangulation target',
	     'The number of triangles to spend for ground detail.  ',
	     10000},
	    {'options.toon', 'Cel shading',
	     'Use a simple cel shading renderer which should run on most ' ..
	    	'GPUs out there.  Should be useful for cartoon fans ' ..
	    	'and the graphically challenged.', false},
	    {'options.simple', 'Simple dashboard',
	     'Replaces the instruments and display with and HUD overlay.',
	     false},
	    {'options.noimagery', 'No ground imagery',
	     'Don\'t load ground imagery.  Allows for lower startup times '..
		'at the expense of dull-looking terrain.', false},
	    {'options.framerate', 'Display framerate',
	     'Display the framerate gauge.', false},
	    {'options.noarrays', 'No vertex arrays',
	     'Advises Techne not to use vertex arrays.  Don\'t check this '..
		'unless you\'re having trouble getting the game to start.',
	     false},
	    {'options.nobufferobjects', 'No buffer objects',
	     'Advises Techne not to use buffer objects.  Likewise, should '..
		'be checked only as a workaround for buggy drivers.',
	     false},
	 },

	 ["Input"] = {
	    {'aviation.sensitivity[1]', 'Aileron sensitivity',
	     'Lowering this means you\'ll have to move the mouse further '..
	     'away to bank the plane.  Consider yourself warned.'},
	    {'aviation.sensitivity[2]', 'Elevator sensitivity',
	     'Same as above only for climbing.'},
	    {'aviation.sensitivity[3]', 'Rudder sensitivity',
	     'This one\'s for the rudder.'},
	 },
	 
	 ["Dynamics"] = {
	 }
      }

      local function stringify (value)
	 if type(value) == "string" then
	    return "\"" .. value .. "\""
	 elseif type(value) == "table" then
	    for i, element in ipairs (value) do
	       value[i] = stringify(element) .. ","
	    end
	  
	    return "{" .. table.concat(value) .. "}"
	 else
	    return tostring(value)
	 end
      end

      if query then
	 -- Set the new values.

	 for argument, value in pairs (query) do
	    assert(loadstring (argument .. " = " .. value))()
	 end

	 if query.save == "true" then
	    local script = io.open (os.getenv ("HOME") .. "/.airrace", "w")

	    script:write ([[
-- This file file has been automagically generated.  You may customize it
-- but rest assured that it will be regenerated next time you click 'save'
-- on the web interface with no regard for your changes whatsoever.
			  ]])

	    for header, group in pairs(groups) do
	       script:write ("\n-- " .. header .. "\n\n")
	       
	       for i, row in ipairs (group) do
		  script:write (row[1] .. " = " .. tostring(assert(loadstring ("return " .. row[1]))()) .. "\n")
	       end
	    end

	    io.close (script)
	 end
      end

      for header, group in pairs(groups) do
	 html = html .. string.format([[

      <tr><th class="striped" colspan="3">%s]], header)
	   
	 for i, row in ipairs (group) do
	    local name, label, description, default, result = unpack (row)
	    local value = assert (loadstring ("return " .. name))() or default

	    html = html .. string.format([[

      <tr class="%s">]], math.mod(i, 2) == 1 and "even" or "odd")

	    if type(value) == "number" then
	       html = html .. string.format([[
        <td class="striped">%s:
        <td class="striped" align="center">
	  <input class="number" type="text" name="%s"
		 value="%g" size="10">]], label, name, value)
	    elseif type(value) == "boolean" then
	       html = html .. string.format([[
	<td class="striped" align="left" colspan="2">
          <input type="hidden" name="%s" value="false" >
	  <input class="check" type="checkbox" name="%s" value="true" %s > %s]],
               name, name, value and "checked" or "", label)
	    end

	    html = html .. string.format([[
	<td class="striped">%s]], description)
	 end
      end

      return html
      ?>
    </table>
  </form>
  <hr> 
</body>
