<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Tracks</title>
  <link rel="stylesheet" href="stylesheet">
  </link>
</head>

<body>
  <hr/> 

  <div class="logo-container">
    <div class="menu-container">
    <a href="/">back</a>
    </div>
  </div>

  <hr/> 

  <p>
    Use the links in the table below to choose the track you want to race.
  </p>

  <table width="100%">
    <col style="width:2em" />

    <?lua
      local html = ""

      for setname, trackset in pairs(airrace.tracksets) do
      	 html = html .. string.format([[
      <tr>
        <th class="striped" colspan="3">%s</th>
      </tr>]], trackset.description)
	   
      	 for i, track in ipairs (trackset) do
      	    html = html .. string.format([[

      <tr class="%s">
        <td class="striped">%d</td>
        <td class="striped" align="left">
          <a href="/briefing?trackset=%s&track=%d">%s</a>
        </td>
        <td class="striped" align="right">%s</td>
      </tr>
      				 ]], math.mod(i, 2) == 1 and "even" or "odd",
			             i, setname, i, track.description,
			             track.best and
				     string.format("%.2f s", track.best) or
				     "N/A")
      	 end
      end

      return html
    ?>
  </table>
  <hr> 
</body>
