-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- Diagram URL: http://localhost:29176/drawdiagram?track=racetracks/track2.lua&width=750&margin={150,300,160,200}&fontsize=25&scale=3&stretch[2]=1&stretch[3]=1&inverted={true,false,true,true,false,false,true,true}&flipped={false,false,true,false,false,false,false}&stems[2]={50,10}&stems[3]={30}&stems[4]={30}&stems[5]={30}&stems[6]={70}

local h, c = 500, 42

aviation.initial = {units.meters {c * -19.491, c * -12.178, h},
		    units.knots (180),
		    90 - 8.929}

aviation.longitudes = {2, 6}
aviation.latitudes = {2, 6}
aviation.time = {142, 18.5}
aviation.turbidity = 6

-- The race-track setup.

airrace.sequence = {1, 2, 3, 4, 5, 4, 6, 7, 8, 1, 2, 3, 4, 5, 4, 6, 7, 8, 1}
airrace.gates = {
   airrace.gate {
      position = {c * -17.344, c * 0.907, h},
      rotation = 90,
      width = 20,
      color = {1.5, 1.5, 1.3},
   },

   airrace.halfgate {
      position = {c * -11.923, c * 9.7, h},
      rotation = 90 + 11.424,
      width = c * 5.2,
      color = {1.5, 1.5, 1.6},
   },

   airrace.gate {
      position = {c * -6.904, c * 10.618, h},
      rotation = 90 + 9.405,
      width = c * 5.2,
      color = {1.5, 1.5, 1.6},
   },

   airrace.gate {
      position = {c * 6.953, c * 1.792, h},
      rotation = 0,
      width = 20,
   },

   airrace.gate {
      position = {c * 16.978, c * 1.821, h},
      rotation = 90 + 67.641,
      color = {1.5, 1.5, 0.1},
      width = 20,
   },

   airrace.gate {
      position = {c * -8.613, c * 0.458, h},
      rotation = 90 + 43.305,
      width = 20,
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = {c * -5.351, c * 0.458, h},
      rotation = 90 - 51.22,
      width = 20,
      color = {1.5, 1.5, 0.4},
   },

   airrace.gate {
      position = {c * -13.557, c * -10.970, h},
      rotation = 90 - 21.22,
      width = 20,
      color = {1.5, 1.5, 0.1},
   },
}
