-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "transitions"
require "director"

-- First unlink the current tree.

if airrace.nodes then
   resources.dofile "airrace/stop.lua"
end

airrace.nodes = {}
airrace.running = true

-- Then proceed to reset it.

resources.dofile (airrace.track)

if not aviation.running then
   resources.dofile "aviation/restart.lua"
else
   assert (not options.survey)
   resources.dofile "aviation/respawn.lua"
end

if aviation.nodes.plane then
   resources.dofile "airrace/tracker.lua"

   if not options.experiment then
      airrace.crashed = {}
      airrace.crossedpylon = {}
      airrace.crossedgate = {}

      resources.dofile "airrace/rules.lua"
   else
      print ("  " .. options.experiment)
      assert(loadfile (options.experiment))()
   end

   airrace.nodes.prestart = director.script {
      link = function(self)
	 self.transition = transitions.fade {
	    duration = -3
	 }

	 aviation.nodes.plane.cockpit.switchgear.switches[3].on = true
      end,

      [3] = function(self)
	 aviation.nodes.plane.cockpit.switchgear.switches[3].on = false

	 self.parent = nil
      end
   }

   airrace.nodes.prestart.parent = graph
end

airrace.nodes.gates = bodies.environment (airrace.gates)
airrace.nodes.gates.parent = aviation.nodes.sky
