-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

aviation.nodes.tracker = frames.event {
   prepare = function(self)
		  local plane = aviation.nodes.plane

		  local v = transforms.tonode(
		               plane,
			       math.normalize (
				  math.subtract(plane.position,
						self.parent.position)))

		  plane.belt.torso.neck.preload = {
		     0,
		     math.clamp (math.asin(-v[3]),
				 units.degrees(0),
				 units.degrees(35)),
		     math.clamp (0.5 * math.pi + math.atan2(v[1], v[2]),
				 units.degrees(-60),
				 units.degrees(60)),
		  }
	       end,

   unlink = function (self, button)
	       aviation.nodes.plane.belt.torso.neck.preload = {0, 0, 0}
	    end
}

airrace.nodes.trackercontrols = frames.event {
   buttonpress = function (self, button)
		    if button == 2 then
		       aviation.nodes.tracker.parent =
			  airrace.gates[airrace.sequence[#airrace.sections + 1] or 1]
		    end
		 end,
      
   buttonrelease = function (self, button)
		      if button == 2 then
			 aviation.nodes.tracker.parent = nil
		      end
		   end
}

airrace.nodes.trackercontrols.parent = aviation.nodes.plane
