-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

aviation.nodes.display = widgets.display {
   size = {graphics.window[1] / graphics.window[2], 1},
   align = {-1, -1},
   
   widgets.row {
      size = {0, 1},
      align = {0, -1},

      altimeter = widgets.column {
	 padding = {0.01, 0},

	 face = widgets.clock {
	    color = {1.0, 0.8, 0.2},
	    opacity = 0.6,

	    radius = {0.1, 0.07},
	    spread = {0, 2 * math.pi},
	    spacing = {2, 5},
	    range = {0, 100},

	    traverse = function (self)
			  local h = aviation.nodes.plane.position[3]

			  self.reading = {h / 10, h / 100, h / 1000}
		       end,

	    markings = frames.transform {
	       [1] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">0</span>"
	       },

	       [2] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">1</span>"
	       },

	       [3] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">2</span>"
	       },

	       [4] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">3</span>"
	       },

	       [5] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">4</span>"
	       },

	       [6] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">5</span>"
	       },

	       [7] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">6</span>"
	       },

	       [8] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">7</span>"
	       },

	       [9] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">8</span>"
	       },

	       [10] = widgets.layout {
		  text = "<span font=\"Sans 10\" color=\"White\">9</span>"
	       },
	    },

	    hands = frames.transform {
	       [1] = shapes.line {
		  color = {1.0, 0.8, 0.2},

		  [1] = {-0.04, 0.6},
		  [2] = {0, 0.7},
		  [3] = {0.04, 0.6},
		  [4] = {0.04, -0.4},
		  [5] = {0, -0.42},
		  [6] = {-0.04, -0.4},
		  [7] = {-0.04, 0.6},
	       },

	       [2] = shapes.line {
		  color = {1.0, 0.8, 0.2},

		  [1] = {-0.07, 0.25},
		  [2] = {0, 0.45},
		  [3] = {0.07, 0.25},
		  [4] = {0.04, 0},
		  [5] = {0.07, -0.2},
		  [6] = {0, -0.22},
		  [7] = {-0.07, -0.2},
		  [8] = {-0.04, 0},
		  [9] = {-0.07, 0.25},
	       },

	       [3] = shapes.line {
		  color = {1.0, 0.8, 0.2},

		  [1] = {-0.02, 0},
		  [2] = {-0.02, 0.8},
		  [3] = {-0.1, 0.9},
		  [4] = {0, 0.92},
		  [5] = {0.1, 0.9},
		  [6] = {0.02, 0.8},
		  [7] = {0.02, 0},
	       },
	    },
	 },

	 label = widgets.layout {
	    color = math.scale ({1.0, 0.8, 0.2}, 1.2),
	    padding = {0.01, 0.01},

	    text = "<span font=\"Sans 10\" color=\"White\">Altimeter</span>",
	 }
      },

      airspeed = widgets.column {
	 padding = {0.01, 0},

	 face = widgets.clock {
	    color = {1.0, 0.8, 0.2},
	    opacity = 0.6,
	    
	    radius = {0.1, 0.07},
	    range = {60, 240},
	    spacing = {5, 4},
	    spread = {2 * math.pi / 5, 9 * math.pi / 5},

	    traverse = function (self)
			  self.reading = transforms.tonode(
			     aviation.nodes.plane,
			     aviation.nodes.plane.velocity)[1] /
			  units.milesperhour (1)
		    end,
	    
	    markings = frames.transform {
	       [1] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">60</span>"
	       },

	       [2] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">80</span>"
	       },

	       [3] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">100</span>"
	       },

	       [4] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">120</span>"
	       },

	       [5] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">140</span>"
	       },

	       [6] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">160</span>"
	       },

	       [7] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">180</span>"
	       },

	       [8] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">200</span>"
	       },

	       [9] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">220</span>"
	       },

	       [10] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">240</span>"
	       },
	    },

	    hands = frames.transform {
	       [1] = shapes.line {
		  color = {1.0, 0.8, 0.2},

		  [1] = {0, -0.1},
		  [2] = {0, 0.75},
		  [3] = {0.05, 0},
		  [4] = {0, -0.1},
		  [5] = {-0.05, 0},
		  [6] = {0, 0.75},
	       },
	    },
	 },

	 label = widgets.layout {
	    color = math.scale ({1.0, 0.8, 0.2}, 1.2),
	    padding = {0.01, 0.01},

	    text = "<span font=\"Sans 10\" color=\"White\">Airspeed</span>",
	 }
      },

      heading = widgets.column {
	 padding = {0.01, 0},
	 
	 face = widgets.clock {
	    color = {1.0, 0.8, 0.2},
	    opacity = 0.6,

	    radius = {0.075, 0.05},
	    range = {0, 360},
	    spacing = {5, 2},
	    spread = {0, 2 * math.pi},

	    
	    traverse = function (self)
			  local v, phi
			  
			  v = math.project (transforms.fromnode (
					       aviation.nodes.plane,
					       {1, 0, 0}),
					    {0, 0, 1})
			  phi = math.deg(math.atan2(v[2], v[1]))

			  self.orientation = transforms.euler (0, 0, phi)
			  self.reading = phi
		       end,

	    hands = frames.transform {
	       [1] = shapes.line {
		  color = {1.0, 0.8, 0.2},

		  [1] = {0, 1},
		  [2] = {0, 0.25},
	       },
	    },
	    
	    markings = frames.transform {
	       [1] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">N</span>"
	       },

	       [4] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">3</span>"
	       },

	       [7] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">6</span>"
	       },

	       [10] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">E</span>"
	       },

	       [13] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">12</span>"
	       },

	       [16] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">15</span>"
	       },

	       [19] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">S</span>"
	       },

	       [22] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">21</span>"
	       },

	       [25] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">24</span>"
	       },

	       [28] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">W</span>"
	       },

	       [31] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">30</span>"
	       },

	       [34] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">33</span>"
	       },
	    },
	 },

	 label = widgets.layout {
	    color = math.scale ({1.0, 0.8, 0.2}, 1.2),
	    padding = {0.01, 0.01},

	    text = "<span font=\"Sans 10\" color=\"White\">Heading</span>",
	 }
      },

      tachometer = widgets.column {
	 padding = {0.01, 0},

	 face = widgets.clock {
	    color = {1.0, 0.8, 0.2},
	    opacity = 0.6,

	    radius = {0.07, 0.05},
	    range = {0, 3500},
	    spacing = {100, 5},
	    spread = {-4 * math.pi / 5, 4 * math.pi / 5},

	    traverse = function (self)
	       self.reading = aviation.nodes.plane.engine.speed / math.pi * 30
	    end,

	    markings = frames.transform {
	       [1] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">0</span>"
	       },

	       [2] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">5</span>"
	       },

	       [3] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">10</span>"
	       },

	       [4] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">15</span>"
	       },

	       [5] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">20</span>"
	       },

	       [6] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">25</span>"
	       },

	       [7] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">30</span>"
	       },

	       [8] = widgets.layout {
		  text = "<span font=\"Sans 7\" color=\"White\">35</span>"
	       },
	    },

	    hands = frames.transform {
	       [1] = shapes.line {
		  color = {1.0, 0.8, 0.2},

		  [1] = {0, -0.1},
		  [2] = {0, 0.75},
		  [3] = {0.05, 0},
		  [4] = {0, -0.1},
		  [5] = {-0.05, 0},
		  [6] = {0, 0.75},
	       },
	    },
	 },

	 label = widgets.layout {
	    color = math.scale ({1.0, 0.8, 0.2}, 1.2),
	    padding = {0.01, 0.01},

	    text = "<span font=\"Sans 10\" color=\"White\">Tachometer</span>",
	 }
      },
   }
}
