-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "director"

local parent

aviation.nodes.cameraman = director.orbit {
   stiffness = 150000,
   damping = 30000,
   
   radius = 50,
   azimuth = math.pi / 3,
   elevation = math.pi / 2,

   controls = frames.event {
      x = 0,
      y = 0,
      
      motion = function (self, button, x, y, dx, dy)
		  local dx, dy
		  local c = 0.01
		  
		  dx, dy = x - self.x, y - self.y
		  
		  if button == 1 then
		     self.parent.azimuth = self.parent.azimuth - c * dx
		     self.parent.elevation = self.parent.elevation - c * dy
		  elseif button == 2 then
		     self.parent.radius = math.clamp(self.parent.radius -
						     100 * c * dy, 0, 500)
		  end
		  self.x, self.y = x, y
	       end,
   },
}   
   
parent = assert(loadstring("return " .. tostring(options.survey)))()

if type (parent) == "userdata" then
   aviation.nodes.cameraman.parent = parent
else
   aviation.nodes.cameraman.parent = frames.transform {
      position = aviation.initial[1],
      orientation = transforms.euler (0,
				      0,
				      aviation.initial[3]),
      parent = graph
   }
end
