
#include "adb.h"

#define MVDB "mvol0.db"
char *ext[] = { "mvol1", "mvol2", "mvol3", "mvol4", "mvol5", "mvol6", NULL } ; 


/* #define DB_NAME "test.db" */

/* #define WHEE "whee" */
/* #define TYPES "types" */
/* #define BLOB "blob" */
/* #define LINK "link" */

char *locale , *codeset ;

void
_adb_lock_read_test(adb_db_t *db, char *filename)
{
  adb_file_t *file ;

  int i ;

  file = adb_file_open(db, filename); 

  printf(" [%d ] ... %s sleep()\n",getpid(), __FUNCTION__); 
/*   sleep(30); */

  for ( i = 1024 ; i ; --i )
    {
     adb_lock_claim(file, 0L, 0L, ADB_LOCK_FILE , ADB_LOCK_READ );
     usleep( rand() % 1024 );
     adb_lock_free( file, 0L, 0L, ADB_LOCK_FILE , ADB_LOCK_READ);
    }
}

void
_adb_lock_write_test(adb_db_t *db, char *filename)
{
 adb_file_t *file ;
 int i ;

 file = adb_file_open(db, filename); 
 printf(" [%d ] ... %s sleep()\n",getpid(), __FUNCTION__);
/*  sleep(30); */

 for ( i = 1024 ; i ; --i )
   {
     adb_lock_claim(file, 0L, 0L, ADB_LOCK_FILE , ADB_LOCK_WRITE );
     usleep( rand() % 1024 );
     adb_lock_free( file, 0L, 0L, ADB_LOCK_FILE , ADB_LOCK_WRITE );

   }
}

int
adb_lock_test(adb_db_t *db, char *filename,int nread, int nwrite)
{
  int status ;
  int n , i ;
  adb_meta_file_t *mfile ;

  adb_meta_open(db);
  mfile = adb_create_file(db, filename, 0);
  adb_meta_commit(db);

  for ( i = 0 ; i < nread ; ++i )
    if ( ! fork() ) /* child */
      {
	signal( SIGINT, SIG_DFL );
	_adb_lock_read_test(db, filename);
	exit(0);
      }

  for ( i = 0 ; i < nwrite ; ++i )
    if ( ! fork() ) /* child */
      {
	signal( SIGINT, SIG_DFL );
	_adb_lock_write_test(db, filename);
	exit(0);
      }

  for ( n = nread + nwrite ; n ; --n )
    wait(&status);
  return 0 ;
}

int
adb_range_show_test(adb_db_t *db UNUSED , char *filename UNUSED)
{
#if 0
  adb_file_t *file ;
  adb_tnx_t *tnx = adb_tnx_new(ADB_TNX_NULL);
  adb_bh_t *bh = NULL ;

  file = adb_file_open(filename);

  bh = __adb_file_activate(tnx, file, ADB_TNX_NULL);
  adb_range_show(bh, file, __func__ );
#endif /* 0 */
  return 0 ;
}

int
adb_blob_test(adb_db_t *db, char *filename)
{
  adb_file_t *file ;
  size_t i ;
  adb_tnx_t *tnx = adb_tnx_new();
  int fail = 0 ;
  void *r ;
  glob_t res ;
  char *name ;
  adb_blob_t *blob ;
  adb_meta_file_t *mfile ;

  adb_meta_open(db);

  mfile = adb_create_file(db, filename, 0);

  adb_create_field(db, mfile, "name", ADB_FIELD_STRING, 256 , 0 );
  adb_create_field(db, mfile, "package", ADB_FIELD_BLOB, 0, EOF);
  
  adb_meta_commit(db);

  file = adb_file_open(db, filename);

  glob("/usr/src/*gz", 0, 0 , &res);

  for ( i = 0 ; i < res.gl_pathc ; ++i )
    {
      name = res.gl_pathv[i] ;
      blob = adb_blob_create(0, ADB_BLOB_FLAG_NAME, name);
      r = adb_insert_by_name(tnx , file , 
			     "name", name ,
			     "package", blob, 
			     NULL );

      if ( r == NULL ) ++fail ;
   }
 
 adb_tnx_end(&tnx);
 printf("Inserted %d failed %d\n",i,fail);
 return 0 ;
}

#define MY_VS_MAX 1024
#undef USE_VSTRING
#define USE_VSTRING 1

int
adb_types_test(adb_db_t *db, char *filename)
{
 adb_file_t *file ;
 int i , j ;
 adb_tnx_t *tnx = adb_tnx_new();
 int fail = 0 ;
 adb_rec_t *r ;
 char str[80] ;
 char *p ;
 char vstr[MY_VS_MAX] ;
 int vlen ;
 adb_meta_file_t *mfile ;

 Adb_debug = ADB_DEBUG_VM ;

 adb_meta_open(db);

 mfile = adb_create_file(db, filename, 0);

 adb_create_field(db, mfile, "int", ADB_FIELD_INT, 0, EOF);
#ifdef USE_VSTRING
 adb_create_field(db, mfile, "vstr", ADB_FIELD_VSTRING, 0, 0 );
#endif
 adb_create_field(db, mfile, "str", ADB_FIELD_STRING, 25600 , 1 ); /* 256 */
 adb_create_field(db, mfile, "ll", ADB_FIELD_LONG_LONG, 0 , 3 );
 adb_create_field(db, mfile, "dbl", ADB_FIELD_DOUBLE, 0 , 2 );
 adb_create_field(db, mfile, "huge-str", ADB_FIELD_STRING, 2048 , EOF );

 adb_meta_commit(db);

 file = adb_file_open(db, filename);

 assert(file != NULL );

  Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP | ADB_DEBUG_VM ;
/*   Adb_debug = ADB_DEBUG_VM */ /* ADB_DEBUG_MISC | ADB_DEBUG_INDEX */ ; 

/*   srand (time (0)); */
  srand(69);

  /* 20k => 15min of disk trashing */
  /* 60k => 2h+ of dtto ( with DEBUG_INDEX ~24h ) */
  /* was: 2000 */
  for ( i = 0 ; i < 20000/* 0 */ ; ++i ) /* 200000 ok for level 2 - 740 blocks rec size 2.5k */
   {
     p = str ;
     *p++ = 'A' + i % 28 ;
     *p++ = 'Z' - i % 26 ;
     *p = 0 ;
#ifdef USE_VSTRING
     vlen = rand() % MY_VS_MAX + 10 ;

     /* vlen = 10 ; */ /* tmp */

     for ( j = 0 ; j < 10 && j < vlen ; ++j )
       vstr[j] = 'a' + rand() % 26 ;
     for ( ; j + 1 < vlen ; ++j )
       vstr[j] = '-' ;
     vstr[j++] = '|' ;
     vstr[j] = 0 ;
     fprintf(stderr,"=== vstr: %s\n",vstr);
#endif     
     adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
     r = adb_insert_by_name(tnx , file , 
			    "int", i ,
#ifdef USE_VSTRING
			    "vstr", vstr, 
#endif
			    "str", /* "Mumble mumble mumble", */ str, 
			    "ll", (long long) i * 10 ,
			    "dbl", (long double) (i + 1 )/ 0.3,
			    "huge-str", "zzzzzzz",
			    NULL );
     adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

     if ( r == NULL )
       {
	 fprintf(stderr,"Fail @%d\n",i);
	 ++fail ;
       }

     if ( Adb_debug & ADB_DEBUG_EXIT )
       break ;
   }
  
  /*   adb_tex(tnx, file , "end" ); */
 
  adb_tnx_end(&tnx);
  printf("Inserted %d failed %d\n",i,fail);
  if ( fail )
    exit(1);

  /* ********** */
  {
    adb_tr_t tr ;
    const adb_rec_t *rec ;
    int j ;
    char *s = NULL ;

    tnx = adb_tnx_new();
    --i ; /* to get last */
    if ( adb_find_by_name(tnx, file, &tr, &rec, TRUE,
#ifdef USE_VSTRING
			  "vstr", vstr, 
#endif
			  "str", /* "Mumble mumble mumble", */ str, 
			  "ll", (long long) i * 10 ,
			  "dbl", (long double) (i + 1 )/ 0.3,
			  NULL))
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("First: %s\n",s);
      }
    for ( j = 0 ; ! adb_next(tnx, file, &tr, &rec ) ; ++j )
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Next: %s\n",s);
      }
    printf("Got %d records forward\n",j);
    adb_tnx_end(&tnx);
  }

  {
    adb_tr_t tr ;
    const adb_rec_t *rec ;
    int j ;
    char *s = NULL ;
    tnx = adb_tnx_new();
    if ( adb_find_by_name(tnx, file, &tr, &rec, TRUE,
#ifdef USE_VSTRING
			  "vstr", vstr, 
#endif
			  "str", /* "Mumble mumble mumble", */ str, 
			  "ll", (long long) i * 10 ,
			  "dbl", (long double) (i + 1 )/ 0.3,
			  NULL))
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find: %s\n",s);
      }
    for ( j = 0 ; ! adb_prev(tnx, file, &tr, &rec ) ; ++j )
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Prev: %s\n",s);
      }
    printf("Got %d records backward\n",j);
    adb_tnx_end(&tnx);
  }

  { /* first/last */
    adb_tr_t tr ;
    const adb_rec_t *rec ;
    char *s = NULL ;
    tnx = adb_tnx_new();
    if ( adb_tr_first(tnx, file, &tr, &rec))
      printf("Can't find 1st!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find 1st: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);    
      }
    adb_delete(tnx, file, rec);

    if ( adb_tr_first(tnx, file, &tr, &rec))
      printf("Can't find 1st!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find 1st: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);    
      }
/*     for ( j = 0 ; ! adb_prev(tnx, file, &tr, &rec ) ; ++j ) */
/*       { */
/* 	adb_fld_get(file, rec, "vstr", &s , NULL ); */
/* 	printf("Prev: %s\n",s); */
/*       } */
/*     printf("Got %d records backward\n",j); */
    

    if ( adb_tr_last(tnx, file, &tr, &rec))
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find last: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);
      }
    adb_tnx_end(&tnx);
  }

  return 0 ;
}

int
adb_idx_test(adb_db_t *db, char *filename)
{
 adb_file_t *file , *si ;
 int i , j , d ;
 int fail = 0 ;
 adb_rec_t *r ;
 char str[80] ;
 char *p ;
 char vstr[MY_VS_MAX] ;
 int vlen ;
 adb_db_t *dbs[2] = { [0] = db } ;
 adb_tnx_t *tnx ; 
 adb_meta_file_t *mfile , *msi ;

 adb_stop(MVDB);
 unlink(MVDB);

 dbs[1] = adb_start_db_multi(MVDB, ext );

 for ( d = 0 ; d < 2 ; ++d )
   {
     tnx = adb_tnx_new();

     adb_meta_open(dbs[d]);

     mfile = adb_create_file_by_name(dbs[d], filename, 
     				    "int", ADB_FIELD_INT, 0, FALSE,
#ifdef USE_VSTRING
				    "vstr", ADB_FIELD_VSTRING, 0, TRUE ,
#endif
				    "str", ADB_FIELD_STRING, 25600 , TRUE ,
				    "ll", ADB_FIELD_LONG_LONG, 0 , TRUE ,
				    "dbl", ADB_FIELD_DOUBLE, 0 , TRUE,
				    "huge-str", ADB_FIELD_STRING, 2048 , FALSE ,
				    NULL);

     msi = adb_create_index_by_name(dbs[d], mfile, d ? 3 : 0 , "s0" ,
				   "ll",
				   "vstr",
				   "str",
				   NULL);
     adb_meta_commit(dbs[d]);

     file = adb_file_open(dbs[d], filename);

     si = adb_file_open_use_index(dbs[d], filename, "s0" );
     
     assert(file != NULL );

     Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ;
     Adb_debug = ADB_DEBUG_VM | ADB_DEBUG_MISC | ADB_DEBUG_DATA_CMP | ADB_DEBUG_INDEX |ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ; 

     /*      srand (time (0)); */
     srand( 666 );
     /* 20k => 15min of disk trashing */
     /* 60k => 2h+ of dtto ( with DEBUG_INDEX ~24h ) */
     /* was: 2000 */
     for ( i = 0 ; i < 2000 ; ++i ) /* 200000 ok for level 2 - 740 blocks rec size 2.5k */
       {
	 p = str ;
	 *p++ = 'A' + i % 28 ;
	 *p++ = 'Z' - i % 26 ;
	 *p = 0 ;
#ifdef USE_VSTRING
	 vlen = rand() % MY_VS_MAX + 10 ;

	 /* vlen = 10 ; */ /* tmp */

	 for ( j = 0 ; j < 10 && j < vlen ; ++j )
	   vstr[j] = 'a' + rand() % 26 ;
	 for ( ; j + 1 < vlen ; ++j )
	   vstr[j] = '-' ;
	 vstr[j++] = '|' ;
	 vstr[j] = 0 ;
	 fprintf(stderr,"=== vstr: %s\n",vstr);
#endif     
	 adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
	 r = adb_insert_by_name(tnx , file , 
				"int", i ,
#ifdef USE_VSTRING
				"vstr", vstr, 
#endif
				"str", /* "Mumble mumble mumble", */ str, 
				"ll", (long long) i * 10 ,
				"dbl", (long double) (i + 1 )/ 0.3,
				"huge-str", "zzzzzzz",
			    NULL );
	 adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

	 if ( r == NULL )
	   {
	     fprintf(stderr,"Fail @%d\n",i);
	     ++fail ;
	   }

	 if ( Adb_debug & ADB_DEBUG_EXIT )
	   break ;
       }
  
     /*   adb_tex(tnx, file , "end" ); */
 
     adb_tnx_end(&tnx);
     printf("Inserted %d failed %d\n",i,fail);
     if ( fail )
       exit(1);

     /* ********** */
     {
       adb_tr_t tr ;
       const adb_rec_t *rec ;
       int j ;
       char *s = NULL ;
       long long ll ;
       int idx ;
       adb_file_t *files[2] = { file , si } ;

       tnx = adb_tnx_new();

       for  ( idx = 0 ; idx <= 1 ; ++idx )
	 {
	   i = 1999 ; /* to get last */
	   if ( adb_find_by_name(tnx, files[idx] , &tr, &rec, TRUE,
#ifdef USE_VSTRING
				 "vstr", vstr, 
#endif
				 "str", /* "Mumble mumble mumble", */ str, 
				 "ll", (long long) i * 10 ,
				 "dbl", (long double) (i + 1 )/ 0.3,
				 NULL))
	     printf("Can't find last!!!\a\n");
	   else
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("First: (%s) %s\n",files[idx]->meta->name,s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll , NULL );
		   printf("First: (%s) %lld\n",files[idx]->meta->name,ll); 
		 }
	     }
	   for ( j = 0 ; ! adb_next(tnx, files[idx], &tr, &rec ) ; ++j )
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("Next: (%s) %s\n",files[idx]->meta->name,s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll , NULL );
		   printf("Next: (%s) %lld\n",files[idx]->meta->name,ll);
		 }
	     }
	   printf("Got %d records forward\n",j);
	   
	   if ( adb_find_by_name(tnx, files[idx], &tr, &rec, TRUE,
#ifdef USE_VSTRING
				 "vstr", vstr, 
#endif
				 "str", /* "Mumble mumble mumble", */ str, 
				 "ll", (long long) i * 10 ,
				 "dbl", (long double) (i + 1 )/ 0.3,
				 NULL))
	     printf("Can't find last!!!\a\n");
	   else
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("Find: (%s) %s\n",files[idx]->meta->name, s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll, NULL );
		   printf("Find: (%s) %lld\n",files[idx]->meta->name,ll);
		 }
	     }
	   for ( j = 0 ; ! adb_prev(tnx, files[idx], &tr, &rec ) ; ++j )
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("Prev: (%s) %s\n",files[idx]->meta->name,s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll, NULL );
		   printf("Prev: (%s) %lld\n",files[idx]->meta->name,ll);
		 }
	     }
	   printf("Got %d records backward\n",j);


	   if ( adb_tr_first(tnx, files[idx], &tr, &rec))
	     printf("Can't find 1st!!!\a\n");
	   else
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("Find 1st: (%s) %s\n",files[idx]->meta->name,s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll, NULL );
		   printf("Find 1st: (%s) %lld\n",files[idx]->meta->name,ll);
		 }
		   /* traverser was initialized by adb_tr_first() */
	       adb_tr_free(&tr);    
	     }
	   adb_delete(tnx, file, rec); /* NOT files[idx] ... secondary
					*  index has NO secondary indexes 
					*/
	   
	   if ( adb_tr_first(tnx, files[idx], &tr, &rec))
	     printf("Can't find 1st!!!\a\n");
	   else
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("Find 1st: (%s) %s\n",files[idx]->meta->name,s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll , NULL );
		   printf("Find 1st: (%s) %lld\n",files[idx]->meta->name,ll);
		 }
	       /* traverser was initialized by adb_tr_first() */
	       adb_tr_free(&tr);    
	     }
     
	   if ( adb_tr_last(tnx, files[idx], &tr, &rec))
	     printf("Can't find last!!!\a\n");
	   else
	     {
	       if ( ! idx )
		 {
		   adb_fld_get(files[idx], rec, "vstr", &s , NULL );
		   printf("Find last: (%s) %s\n",files[idx]->meta->name,s);
		 }
	       else
		 {
		   adb_fld_get(files[idx], rec, "ll", &ll , NULL );
		   printf("Find last: (%s) %lld\n",files[idx]->meta->name,ll);
		 }
	       /* traverser was initialized by adb_tr_first() */
	       adb_tr_free(&tr);
	     }
	 }
     }
     adb_tnx_end(&tnx);
   }

 adb_stop("mvol0.db");
 return 0 ;
}

#define FORTUNES "/usr/share/games/fortunes/fortunes"

int
adb_link_test(adb_db_t *db, char *filename)
{
 adb_file_t *file , *blob ;
 int i , d ;
 adb_db_t *dbs[2] = { [0] = db } ;
 adb_tnx_t *tnx ; 
 FILE *FP ;
 int b_count = 0 , w_count = 0 ;
 adb_tr_t tr ;
 adb_meta_file_t *mfile , *mblob ;



 adb_stop(MVDB);
 unlink(MVDB);

 dbs[1] = adb_start_db_multi(MVDB, ext );

 for ( d = 0 ; d < 2 ; ++d )
   {
     tnx = adb_tnx_new();

     adb_meta_open(dbs[d]);

     mfile = adb_create_file_by_name(dbs[d], filename, 
#ifdef USE_VSTRING
				     "word", ADB_FIELD_VSTRING, 0, TRUE,
#else
				     "word", ADB_FIELD_STRING, 128, TRUE ,
#endif
				     "where", ADB_FIELD_LINK, 0 , FALSE ,
				     NULL);
     
     mblob = adb_create_file_by_name(dbs[d], "blob", 
				     "id", ADB_FIELD_INT, 0, TRUE, 
				     "text", ADB_FIELD_BLOB_STRING, 0, FALSE,
				     NULL);

     adb_meta_commit(dbs[d]);

     if ( ( FP = fopen(FORTUNES, "r")) == NULL )
       {
	 ADB_ERROR("Can't open fortunes file `%s'\n",FORTUNES);
	 abort();
       }
     file = adb_file_open(dbs[d], filename);
     blob = adb_file_open(dbs[d], "blob");
     
     assert(file != NULL );
     assert(blob != NULL );

     Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ;
     Adb_debug = ADB_DEBUG_LINK | ADB_DEBUG_VM | ADB_DEBUG_MISC | ADB_DEBUG_INDEX/* | ADB_DEBUG_DATA_CMP | ADB_DEBUG_INDEX |ADB_DEBUG_RANGE_CMP */ ; 
     Adb_debug = ADB_DEBUG_MISC ;

     srand (time (0));

     for ( i = 0 ; ! feof(FP) ; ++i ) 
       {
	 char *buf = NULL ;
	 size_t size = 0 ;
	 int n ;
	 FILE *TMP ;
	 adb_blob_t *the_blob ;
	 char *word ;
	 adb_rec_t *blob_rec ;
	 const adb_rec_t *rec ;
	 if ( (TMP = fopen("/tmp/f.txt","w")) == NULL )
	   abort();

	/*  Adb_tnx_check(tnx); */

	 for ( ; ; )
	   {
	     if ( (n = getline(&buf, &size, FP )) == EOF )
	       break ;
	     if ( *buf == '%' )
	       break ;
	     fputs(buf, TMP);
	   }
	 fclose(TMP);
	 
/* 	 Adb_tnx_check(tnx); */

	 the_blob = adb_blob_create(0, ADB_BLOB_FLAG_NAME, "/tmp/f.txt");
	 /* Adb_tnx_check(tnx); */
	 blob_rec = adb_insert_by_name(tnx , blob , 
				       "id", i ,
				       "text", the_blob, 
				       NULL );
	 /* Adb_tnx_check(tnx); */
	 if ( blob_rec )
	   ++b_count ;

	 if ( (TMP = fopen("/tmp/f.txt","r")) == NULL )
	   abort();

	 for ( ; ; )
	   {
	     const char *delimiters = " \n\t.!?\"'`:;-\a" ;
	     if ( (n = getline(&buf, &size, FP )) == EOF )
	       break ;
	     
	     for ( word = strtok(buf, delimiters) ;
		   word ;
		   word = strtok(NULL, delimiters) )
	       {
/* 	     if ( fscanf( TMP, "%as", &word) == EOF ) */
/* 	       break ; */
		 if ( strlen(word) <= 4 )
		   continue ;
		 
		 if ( adb_find_by_name(tnx, file , &tr, &rec, TRUE,
				   "word", word, 
				   NULL))
		   {
		     fprintf(stderr,"No item `%s'\n",word);
		     adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

		     rec = adb_insert_by_name(tnx , file , 
					      "word", word, 
					      NULL );

		     adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

		     if ( rec == NULL )
		       abort();
		     assert( rec->magic == ADB_MAGIC_RECORD );
		   }
		 else
		   {
		     fprintf(stderr,"Found item `%s' @ %p\n",word,rec);
		     assert(rec->magic == ADB_MAGIC_RECORD);
		   }


		 /* Adb_tnx_check(tnx); */

		 /* make copy of rec !!!! (malloc) */
		 adb_obj_has_a(tnx, "where", file, (adb_rec_t *)rec, blob, blob_rec );
		 /* Adb_tnx_check(tnx); */

		 ++w_count ;
	       }
	   }
	 fclose(TMP);

	 printf("Inserted %d words , %d blobs\n",w_count,b_count);
       }
     adb_tnx_end(&tnx);

     /* read */
     {
       adb_tr_t tr ;
       int r , l ;
       adb_link_traverser_t *lt ;
       char *s = NULL ;
       const adb_rec_t *rec , *a ;
       tnx = adb_tnx_new();
     
       for ( r = 0 ;  ; ++r )
	 {
	   if ( ! r )
	     {
	       if ( adb_tr_first(tnx, file, &tr, &rec))
		 abort();
	     }
	   else
	     {
	       if (  adb_next(tnx, file, &tr, &rec ) )
		 break ;
	     }
	   
	   lt = adb_link_get(tnx, file, rec, "where");
	   assert(lt);
	   
	   adb_fld_get(file, rec, "word", &s , NULL );



	   for ( l = 0 ; ; ++l )
	     {
	       a = adb_link_read(tnx, lt );
	       if ( ! a )
		 break ;
	     }
	   fprintf(stderr,"Word `%s' has %llu link(s) %d\n",
		   s, lt->link->count, l );

	   adb_link_free(lt);

	 }
       adb_tnx_end(&tnx);
     }
   }
 
 adb_stop("mvol0.db");

 return 0 ;
}

int
adb_link_blob_test(adb_db_t *db, char *filename)
{
  adb_tr_t tr ;
  int /* r , */ l ;
  adb_link_traverser_t *lt ;
  char *s = NULL ;
  const adb_rec_t *rec , *a ;
  
  adb_tnx_t *tnx = adb_tnx_new();
  adb_file_t *file = adb_file_open(db, filename);
  adb_file_t *blob = blob = adb_file_open(db, "blob");
  size_t size = 0 , n ;
  char *buf = NULL ;
  
  for ( ; ; )
    {
      printf("\nWord : "); fflush(stdout);
      if ( (n = getline(&buf, &size, stdin )) == EOF )
	break ;
      buf[strlen(buf)-1] = 0 ; /* zap \n */
      if ( adb_find_by_name(tnx, file , &tr, &rec, TRUE,
			    "word", buf, 
			    NULL))
	{
	  printf("Exact search for `%s' failed\n",buf);
	  if ( adb_find_by_name(tnx, file , &tr, &rec, FALSE,
				"word", buf, 
				NULL))
	    {
	      printf("Close search for `%s' failed (this is strange)\n",buf);
	      continue ;
	    }
	}
      adb_fld_get(file, rec, "word", &s , NULL );

	   
      lt = adb_link_get(tnx, file, rec, "where");
      assert(lt);
	   
      adb_fld_get(file, rec, "word", &s , NULL );


      for ( l = 0 ; ; ++l )
	{
	  char *buf = NULL ;
	  a = adb_link_read(tnx, lt );
	  if ( ! a )
	    break ;
	  adb_fld_get(blob, a, "text", &buf , NULL );
	  printf("------------\n");
	  printf("%s",buf);
	  printf("------------\n");
	}

      printf("Word `%s' has %llu link(s) %d\n",
	     s, lt->link->count, l );


      adb_link_free(lt);

    }
  adb_tnx_end(&tnx);

  return 0 ;
}

int
adb_mvol_test(adb_db_t *db, char *filename)
{
 adb_file_t *file  ;
 int i , j , d ;
 int fail = 0 ;
 adb_rec_t *r ;
 char str[80] ;
 char *p ;
 char vstr[MY_VS_MAX] ;
 int vlen ;
 adb_db_t *dbs[2] = { [0] = db } ;
 adb_tnx_t *tnx ; 
 adb_meta_file_t *mfile ;

 adb_stop(MVDB);
 unlink(MVDB);

 dbs[1] = adb_start_db_multi(MVDB, ext );

 adb_bi_start(dbs[1], "/u/tmp" );

 for ( d = 0 ; d < 2 ; ++d )
   {
     tnx = adb_tnx_new();

     adb_meta_open(dbs[d]);

     mfile = adb_create_file(dbs[d], filename, 0);
     
     adb_create_field(dbs[d], mfile, "int", ADB_FIELD_INT, 0, EOF);
#ifdef USE_VSTRING
     adb_create_field(dbs[d], mfile, "vstr", ADB_FIELD_VSTRING, 0, 0 );
#endif
     adb_create_field(dbs[d], mfile, "str", ADB_FIELD_STRING, 25600 , 1 ); /* 256 */
     adb_create_field(dbs[d], mfile, "ll", ADB_FIELD_LONG_LONG, 0 , 3 );
     adb_create_field(dbs[d], mfile, "dbl", ADB_FIELD_DOUBLE, 0 , 2 );
     adb_create_field(dbs[d], mfile, "huge-str", ADB_FIELD_STRING, 2048 , EOF );

     adb_meta_commit(dbs[d]);

     file = adb_file_open(dbs[d], filename);
     assert(file != NULL );


     Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ;
     Adb_debug = ADB_DEBUG_VM | ADB_DEBUG_MISC /* | ADB_DEBUG_INDEX |ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  */ ; 

     srand (time (0));

     /* 20k => 15min of disk trashing */
     /* 60k => 2h+ of dtto ( with DEBUG_INDEX ~24h ) */
     /* was: 2000 */
     for ( i = 0 ; i < 2000 ; ++i ) /* 200000 ok for level 2 - 740 blocks rec size 2.5k */
       {
	 p = str ;
	 *p++ = 'A' + i % 28 ;
	 *p++ = 'Z' - i % 26 ;
	 *p = 0 ;
#ifdef USE_VSTRING
	 vlen = rand() % MY_VS_MAX + 10 ;

	 /* vlen = 10 ; */ /* tmp */

	 for ( j = 0 ; j < 10 && j < vlen ; ++j )
	   vstr[j] = 'a' + rand() % 26 ;
	 for ( ; j + 1 < vlen ; ++j )
	   vstr[j] = '-' ;
	 vstr[j++] = '|' ;
	 vstr[j] = 0 ;
	 fprintf(stderr,"=== vstr: %s\n",vstr);
#endif     
	 adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
	 r = adb_insert_by_name(tnx , file , 
				"int", i ,
#ifdef USE_VSTRING
				"vstr", vstr, 
#endif
				"str", /* "Mumble mumble mumble", */ str, 
				"ll", (long long) i * 10 ,
				"dbl", (long double) (i + 1 )/ 0.3,
				"huge-str", "zzzzzzz",
			    NULL );
	 adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

	 if ( r == NULL )
	   {
	     fprintf(stderr,"Fail @%d\n",i);
	     ++fail ;
	   }

	 if ( Adb_debug & ADB_DEBUG_EXIT )
	   break ;
       }
  
     /*   adb_tex(tnx, file , "end" ); */
 
     adb_tnx_end(&tnx);
     printf("Inserted %d failed %d\n",i,fail);
     if ( fail )
       exit(1);

     /* ********** */
     {
       adb_tr_t tr ;
       const adb_rec_t *rec ;
       int j ;
       char *s = NULL ;
       
       tnx = adb_tnx_new();
       --i ; /* to get last */
       if ( adb_find_by_name(tnx, file, &tr, &rec, TRUE,
#ifdef USE_VSTRING
			     "vstr", vstr, 
#endif
			     "str", /* "Mumble mumble mumble", */ str, 
			     "ll", (long long) i * 10 ,
			     "dbl", (long double) (i + 1 )/ 0.3,
			     NULL))
	 printf("Can't find last!!!\a\n");
       else
	 {
	   adb_fld_get(file, rec, "vstr", &s , NULL );
	   printf("First: %s\n",s);
	 }
       for ( j = 0 ; ! adb_next(tnx, file, &tr, &rec ) ; ++j )
	 {
	   adb_fld_get(file, rec, "vstr", &s , NULL );
	   printf("Next: %s\n",s);
	 }
       printf("Got %d records forward\n",j);
       adb_tnx_end(&tnx);
     }
   } /* for */
 {
   adb_tr_t tr ;
   const adb_rec_t *rec ;
   int j ;
    char *s = NULL ;
    tnx = adb_tnx_new();
    if ( adb_find_by_name(tnx, file, &tr, &rec, TRUE,
#ifdef USE_VSTRING
			  "vstr", vstr, 
#endif
			  "str", /* "Mumble mumble mumble", */ str, 
			  "ll", (long long) i * 10 ,
			  "dbl", (long double) (i + 1 )/ 0.3,
			  NULL))
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find: %s\n",s);
      }
    for ( j = 0 ; ! adb_prev(tnx, file, &tr, &rec ) ; ++j )
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Prev: %s\n",s);
      }
    printf("Got %d records backward\n",j);
    adb_tnx_end(&tnx);
  }

  { /* first/last */
    adb_tr_t tr ;
    const adb_rec_t *rec ;
    char *s = NULL ;
    tnx = adb_tnx_new();
    if ( adb_tr_first(tnx, file, &tr, &rec))
      printf("Can't find 1st!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find 1st: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);    
      }
    adb_delete(tnx, file, rec);

    if ( adb_tr_first(tnx, file, &tr, &rec))
      printf("Can't find 1st!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find 1st: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);    
      }
/*     for ( j = 0 ; ! adb_prev(tnx, file, &tr, &rec ) ; ++j ) */
/*       { */
/* 	adb_fld_get(file, rec, "vstr", &s , NULL ); */
/* 	printf("Prev: %s\n",s); */
/*       } */
/*     printf("Got %d records backward\n",j); */
    

    if ( adb_tr_last(tnx, file, &tr, &rec))
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find last: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);
      }
    adb_tnx_end(&tnx);
  }

 adb_stop("mvol0.db");
 return 0 ;
}

int
adb_find_create_test(adb_db_t *db, char *filename)
{
 adb_file_t *file  ;
 int i , j , d ;
 int fail = 0 ;
 adb_rec_t *r ;
 char str[80] ;
 char *p ;
 char vstr[MY_VS_MAX] ;
 int vlen ;
 adb_db_t *dbs[2] = { [0] = db } ;
 adb_tnx_t *tnx ; 
 adb_meta_file_t *mfile ;

 adb_stop(MVDB);
 unlink(MVDB);

 dbs[1] = adb_start_db_multi(MVDB, ext );

 adb_bi_start(dbs[1], "/u/tmp" );

 for ( d = 0 ; d < 2 ; ++d )
   {
     tnx = adb_tnx_new();

     adb_meta_open(dbs[d]);

     mfile = adb_create_file(dbs[d], filename, 0);
     
     adb_create_field(dbs[d], mfile, "A", ADB_FIELD_INT, 0, 0);
     adb_create_field(dbs[d], mfile, "B", ADB_FIELD_INT, 0, 1);
     adb_create_field(dbs[d], mfile, "C", ADB_FIELD_INT, 0, 2);
     adb_create_field(dbs[d], mfile, "D-vstr", ADB_FIELD_VSTRING, 0, 3 );
     adb_create_field(dbs[d], mfile, "E-str", ADB_FIELD_STRING, 25600 , 4 ); /* 256 */
     adb_create_field(dbs[d], mfile, "huge-str", ADB_FIELD_STRING, 2048 , EOF );

     adb_meta_commit(dbs[d]);

     file = adb_file_open(dbs[d], filename);
     assert(file != NULL );


     Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ;
     Adb_debug = ADB_DEBUG_VM | ADB_DEBUG_MISC | ADB_DEBUG_INDEX |ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ; 

/*      srand (time (0)); */
     srand(0xbeef);

     /* 20k => 15min of disk trashing */
     /* 60k => 2h+ of dtto ( with DEBUG_INDEX ~24h ) */
     /* was: 2000 */
     for ( i = 0 ; i < 20000 ; ++i ) /* 200000 ok for level 2 - 740 blocks rec size 2.5k */
       {
	 p = str ;
	 *p++ = 'A' + i % 28 ;
	 *p++ = 'Z' - i % 26 ;
	 *p = 0 ;
#ifdef USE_VSTRING
	 vlen = rand() % MY_VS_MAX + 10 ;

	 /* vlen = 10 ; */ /* tmp */

	 for ( j = 0 ; j < 10 && j < vlen ; ++j )
	   vstr[j] = 'a' + rand() % 26 ;
	 for ( ; j + 1 < vlen ; ++j )
	   vstr[j] = '-' ;
	 vstr[j++] = '|' ;
	 vstr[j] = 0 ;
	 fprintf(stderr,"=== vstr: %s\n",vstr);
#endif     
	 adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
	 r = adb_insert_by_name(tnx , file , 
				"A", UINT_MAX % ( (i+1) * 10 ) ,
				"B", UINT_MAX % ( (i+1) * 16 ) ,
				"C", UINT_MAX % ( (i+1) * 27 ) ,
				"D-vstr", vstr,
				"E-str", str, 
				"huge-str", "zzzzzzz",
				NULL );
	 adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

	 if ( r == NULL )
	   {
	     fprintf(stderr,"Fail @%d\n",i);
	     ++fail ;
	   }

	 if ( Adb_debug & ADB_DEBUG_EXIT )
	   break ;
       }
  
     /*   adb_tex(tnx, file , "end" ); */
 
     adb_tnx_end(&tnx);
     printf("Inserted %d failed %d\n",i,fail);
/*      if ( fail ) */
/*        exit(1); */
   }
 adb_stop(MVDB);
 return 0 ;
}


int
adb_find_where_test(adb_db_t *db, char *filename)
{
 adb_file_t *file  ;
 int i , d ;
 int fail = 0 ;
 const adb_rec_t *rec ;
 adb_db_t *dbs[2] = { [0] = db } ;
 adb_tnx_t *tnx ; 
 int rv ;

/*  adb_stop(MVDB); */
/*  unlink(MVDB); */

/*  dbs[1] = adb_start_db_multi(MVDB, ext ); */

/*  adb_bi_start(dbs[1], "/u/tmp" ); */

 for ( d = 0 ; d < 2 ; ++d )
   {
     tnx = adb_tnx_new();

     file = adb_file_open(dbs[d], filename);
     assert(file != NULL );


     Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ;
     Adb_debug = ADB_DEBUG_VM | ADB_DEBUG_MISC | ADB_DEBUG_INDEX |ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ; 

     /*      srand (time (0)); */
     srand(0xbeef);

     /* 20k => 15min of disk trashing */
     /* 60k => 2h+ of dtto ( with DEBUG_INDEX ~24h ) */
     /* was: 2000 */
     for ( i = 0 ; i < 2000 ; ++i ) /* 200000 ok for level 2 - 740 blocks rec size 2.5k */
       {
	 adb_tr_t tr ;
	 
	 adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
	 rv = adb_find_first_where(tnx , file , &tr, &rec,
				   "A", UINT_MAX % ( (i+1) * 10 ) ,
				   "B", UINT_MAX % ( (i+1) * 16 ) ,
				   NULL );
	 
	 /* 				"C", UINT_MAX % ( (i+1) * 27 ) , */
	 /* 				"D-vstr", vstr, */
	 /* 				"E-str",  str,  */
	 /* 				"huge-str", "zzzzzzz", */
	 /* 				NULL ); */
	 adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

	 if ( rv )
	   {
	     fprintf(stderr,"Fail @%d\n",i);
	     printf("Nonexistent %d, %d\n", 
		    UINT_MAX % ( (i+1) * 10 ) ,
		    UINT_MAX % ( (i+1) * 16 ) 
		    );

	     ++fail ;
	   }
	 else
	   {
	     int a, b, c;
	     char *d = NULL ;
	     adb_fld_get(file, rec, 
			 "A", &a , 
			 "B", &b , 
			 "C", &c ,
			 "D-vstr", &d ,
			 NULL );

	     printf("Searched for %d, %d\n", 
		    UINT_MAX % ( (i+1) * 10 ) ,
		    UINT_MAX % ( (i+1) * 16 ) 
		    );

	     printf("Found %d, %d, %d, %s\n", a, b, c, d);
	   }
     /*   adb_tex(tnx, file , "end" ); */
	 
       }
     adb_tnx_end(&tnx);
     printf("Searched %d failed %d\n",i,fail);
     if ( fail )
       exit(1);
   }
 adb_stop(MVDB);
 return 0 ;
}

/* export LANG=cs_CZ.utf8 */
int
adb_i18n_test(adb_db_t *db, char *filename)
{
 adb_file_t *file  ;
 adb_meta_file_t *mfile ;
 int utf8_mode = 0 , iso_8859_2_mode = 0 , fail = 0 ;
 FILE *FP ;

 size_t size = 0 ;
 char *buf = NULL ;
 int n , lines ;


 adb_rec_t *rec ;
 adb_tnx_t *tnx ;
 
 iconv_t cd ;

 char *conv_buf = NULL ;
 size_t conv_size = 0 ;

/*  if ( ( locale = setlocale(LC_ALL, "")) == NULL ) */
/*    ADB_ERROR("setlocale failed"); */
/*  else */
/*    ADB_WARNING("locale is: %s\n",locale); */

 if ( ! strstr(locale, "cs_CZ") )
   ADB_ERROR("This test requires czech language environment");

/*  codeset = nl_langinfo(CODESET); */


 utf8_mode = (strcmp(codeset, "UTF-8") == 0);
 iso_8859_2_mode = (strcmp(codeset, "ISO-8859-2") == 0);

 if ( ! utf8_mode && ! iso_8859_2_mode )
   ADB_ERROR("This test requires czech environment with charset UTF-8 or ISO-8859-2");
 
 if ( iso_8859_2_mode )
   {
     if ( ( FP = fopen("gpl-cz.txt", "r")) == NULL )
       ADB_ERROR("Can't open gpl-cz.txt, are we in directory avldb-0.x.x now ???");
   }
 else /* UTF-8 */
   {
     if ( ( FP = fopen("gpl-cz-UTF8.txt", "r")) == NULL )
       ADB_ERROR("Can't open gpl-cz-UTF8.txt, are we in directory avldb-0.x.x now ???");
   }

 ADB_WARNING("Codeset: %s\n",nl_langinfo(CODESET));

 cd = iconv_open("WCHAR_T", codeset);
 if (cd == (iconv_t) -1)
   {
      /* Something went wrong.  */
     if (errno == EINVAL)
       ADB_ERROR( "conversion from '%s' to wchar_t not available",
		  codeset);
     else
       ADB_BUG("iconv_open");
     
     return -1;
   }

 adb_meta_open(db);
 mfile = adb_create_file(db, filename, 0);

 adb_create_field(db, mfile, "i18n", ADB_FIELD_WCHAR, 0, 0);
 adb_meta_commit(db);

 file = adb_file_open(db, filename);

 tnx = adb_tnx_new();

 printf("pid %d\n",getpid()); fflush(stdout); /* sleep(20); */

 for ( lines = 0 ; ; ++lines )
   {
     int wn ;
     char *i_buf, *i_conv_buf ;
     size_t i_size, i_conv_size , nconv ;

     if ( (n = getline(&buf, &size, FP )) == EOF )
       {
	 /* Now write out the byte sequence to get into the
	    initial state if this is necessary.  */
	 iconv (cd, NULL, NULL, &conv_buf, &conv_size);
	 if (iconv_close (cd) != 0)
	   perror ("iconv_close");
	 break ;
       }
     wn = n * sizeof(wchar_t) * 2 ;
     if ( wn > conv_size )
       {
	 if ( conv_size )
	   conv_buf = realloc(conv_buf, wn);
	 else
	   conv_buf = Malloc(wn);
	 conv_size = wn ;
       }
     
     i_buf = buf ; i_size = n ; 
     i_conv_buf = conv_buf ; i_conv_size = conv_size ;

     /* Do the conversion.  */
     nconv = iconv (cd, &i_buf, &i_size, &i_conv_buf, &i_conv_size);
     if (nconv == (size_t) -1)
       {
	 /* Not everything went right.  It might only be
	    an unfinished byte sequence at the end of the
	    buffer.  Or it is a real problem.  */
	 switch (errno)
	   {
	   case EINVAL:
	     /* This is harmless.  Simply move the unused
		bytes to the beginning of the buffer so that
		they can be used in the next round.  */
	     memmove (buf, i_buf, i_size);
	     break ;
	   case E2BIG:
	     ADB_BUG("Output buffer too small");
	     break ;
	   case EILSEQ:
	     ADB_BUG("Invalid byte sequence in the input");
	     break ;
	   default:
	     break ;
	   }
       }
     
     /* Terminate the output string.  */
     if ( i_conv_size >= sizeof (wchar_t))
       *((wchar_t *) i_conv_buf) = L'\0';
     
     adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

     rec = adb_insert_by_name(tnx , file , 
			      "i18n", conv_buf, 
			      NULL );
     if ( rec == NULL )
       ++fail ;

     adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
   }

 fclose(FP);
 adb_tnx_end(&tnx);

 printf("Inserted %d lines, %d failed\n", lines, fail);

 return 0 ;
}

int
adb_mvol_undo_test(adb_db_t *db, char *filename)
{
 adb_file_t *file  ;
 int i , j , d ;
 int fail = 0 ;
 adb_rec_t *r ;
 char str[80] ;
 char *p ;
 char vstr[MY_VS_MAX] ;
 int vlen ;
 adb_db_t *dbs[2] = { [0] = db } ;
 adb_tnx_t *tnx ; 
 adb_meta_file_t *mfile ;

 adb_stop(MVDB);
 unlink(MVDB);

 dbs[1] = adb_start_db_multi(MVDB, ext );

 adb_bi_start(dbs[1], "/u/tmp" );

 for ( d = 0 ; d < 2 ; ++d )
   {
     tnx = adb_tnx_new();

     adb_meta_open(dbs[d]);

     mfile = adb_create_file(dbs[d], filename, 0);
     
     adb_create_field(dbs[d], mfile, "int", ADB_FIELD_INT, 0, EOF);
#ifdef USE_VSTRING
     adb_create_field(dbs[d], mfile, "vstr", ADB_FIELD_VSTRING, 0, 0 );
#endif
     adb_create_field(dbs[d], mfile, "str", ADB_FIELD_STRING, 25600 , 1 ); /* 256 */
     adb_create_field(dbs[d], mfile, "ll", ADB_FIELD_LONG_LONG, 0 , 3 );
     adb_create_field(dbs[d], mfile, "dbl", ADB_FIELD_DOUBLE, 0 , 2 );
     adb_create_field(dbs[d], mfile, "huge-str", ADB_FIELD_STRING, 2048 , EOF );

     adb_meta_commit(dbs[d]);

     file = adb_file_open(dbs[d], filename);
     assert(file != NULL );


     Adb_debug = ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  ;
     Adb_debug = ADB_DEBUG_VM | ADB_DEBUG_MISC /* | ADB_DEBUG_INDEX |ADB_DEBUG_RANGE_CMP | ADB_DEBUG_DATA_CMP  */ ; 

     srand (time (0));

     /* 20k => 15min of disk trashing */
     /* 60k => 2h+ of dtto ( with DEBUG_INDEX ~24h ) */
     /* was: 2000 */
     for ( i = 0 ; i < 2000 ; ++i ) /* 200000 ok for level 2 - 740 blocks rec size 2.5k */
       {
	 p = str ;
	 *p++ = 'A' + i % 28 ;
	 *p++ = 'Z' - i % 26 ;
	 *p = 0 ;
#ifdef USE_VSTRING
	 vlen = rand() % MY_VS_MAX + 10 ;

	 /* vlen = 10 ; */ /* tmp */

	 for ( j = 0 ; j < 10 && j < vlen ; ++j )
	   vstr[j] = 'a' + rand() % 26 ;
	 for ( ; j + 1 < vlen ; ++j )
	   vstr[j] = '-' ;
	 vstr[j++] = '|' ;
	 vstr[j] = 0 ;
	 fprintf(stderr,"=== vstr: %s\n",vstr);
#endif     
	 adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
	 r = adb_insert_by_name(tnx , file , 
				"int", i ,
#ifdef USE_VSTRING
				"vstr", vstr, 
#endif
				"str", /* "Mumble mumble mumble", */ str, 
				"ll", (long long) i * 10 ,
				"dbl", (long double) (i + 1 )/ 0.3,
				"huge-str", "zzzzzzz",
			    NULL );
	 adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

	 if ( r == NULL )
	   {
	     fprintf(stderr,"Fail @%d\n",i);
	     ++fail ;
	   }

	 if ( Adb_debug & ADB_DEBUG_EXIT )
	   break ;
       }
     adb_tnx_end(&tnx);
     printf("Inserted %d failed %d\n",i,fail);
     if ( fail )
       exit(1);


     /* *************************** UNDO ******************************************** */
     tnx = adb_tnx_new();

     fprintf(stderr,"*************************** UNDO ************************************\n");
     for ( i = 10000 ; i < 11000 ; ++i )
       {
	 p = str ;
	 *p++ = 'A' + i % 28 ;
	 *p++ = 'Z' - i % 26 ;
	 *p = 0 ;
#ifdef USE_VSTRING
	 vlen = rand() % MY_VS_MAX + 10 ;

	 /* vlen = 10 ; */ /* tmp */

	 for ( j = 0 ; j < 10 && j < vlen ; ++j )
	   vstr[j] = 'a' + rand() % 26 ;
	 for ( ; j + 1 < vlen ; ++j )
	   vstr[j] = '-' ;
	 vstr[j++] = '|' ;
	 vstr[j] = 0 ;
	 fprintf(stderr,"=== vstr: %s\n",vstr);
#endif     
	 adb_lock_claim( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );
	 r = adb_insert_by_name(tnx , file , 
				"int", i ,
#ifdef USE_VSTRING
				"vstr", vstr, 
#endif
				"str", /* "Mumble mumble mumble", */ str, 
				"ll", (long long) i * 10 ,
				"dbl", (long double) (i + 1 )/ 0.3,
				"huge-str", "zzzzzzz",
			    NULL );
	 adb_lock_free( file, 0LL, 0LL, ADB_LOCK_FILE, ADB_LOCK_WRITE );

	 if ( r == NULL )
	   {
	     fprintf(stderr,"Fail @%d\n",i);
	     ++fail ;
	   }

	 if ( Adb_debug & ADB_DEBUG_EXIT )
	   break ;
       }
     fprintf(stderr,"Inserted %d failed %d\n",i,fail);
     if ( fail )
       exit(1);

     adb_tnx_abort(&tnx);
     fprintf(stderr,"*************************** UNDO DONE ********************************\n");
     /* *************************** UNDO END ***************************************** */

     /*   adb_tex(tnx, file , "end" ); */
 
     /* ********** */
     {
       adb_tr_t tr ;
       const adb_rec_t *rec ;
       int j ;
       char *s = NULL ;
       
       tnx = adb_tnx_new();
#if 0
       i = 1999 ; /* to get last */
       if ( adb_find_by_name(tnx, file, &tr, &rec, TRUE,
#ifdef USE_VSTRING
			     "vstr", vstr, 
#endif
			     "str", /* "Mumble mumble mumble", */ str, 
			     "ll", (long long) i * 10 ,
			     "dbl", (long double) (i + 1 )/ 0.3,
			     NULL))
#else /* 0 */
	 if ( adb_tr_first(tnx, file, &tr, &rec) )
#endif /* 0 */
	 printf("Can't find last!!!\a\n");
       else
	 {
	   adb_fld_get(file, rec, "vstr", &s , NULL );
	   printf("First: %s\n",s);
	 }
       for ( j = 0 ; ! adb_next(tnx, file, &tr, &rec ) ; ++j )
	 {
	   adb_fld_get(file, rec, "vstr", &s , NULL );
	   printf("Next: %s\n",s);
	 }
       printf("Got %d records forward\n",j);
       adb_tnx_end(&tnx);
     }
   } /* for */
 {
   adb_tr_t tr ;
   const adb_rec_t *rec ;
   int j ;
    char *s = NULL ;
    tnx = adb_tnx_new();
#if 0
    if ( adb_find_by_name(tnx, file, &tr, &rec, TRUE,
#ifdef USE_VSTRING
			  "vstr", vstr, 
#endif
			  "str", /* "Mumble mumble mumble", */ str, 
			  "ll", (long long) i * 10 ,
			  "dbl", (long double) (i + 1 )/ 0.3,
			  NULL))
#else /* 0 */
     if ( adb_tr_last(tnx, file, &tr, &rec) ) 
#endif /* 0 */
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find: %s\n",s);
      }
    for ( j = 0 ; ! adb_prev(tnx, file, &tr, &rec ) ; ++j )
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Prev: %s\n",s);
      }
    printf("Got %d records backward\n",j);
    adb_tnx_end(&tnx);
  }

  { /* first/last */
    adb_tr_t tr ;
    const adb_rec_t *rec ;
    char *s = NULL ;
    tnx = adb_tnx_new();
    if ( adb_tr_first(tnx, file, &tr, &rec))
      printf("Can't find 1st!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find 1st: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);    
      }
    adb_delete(tnx, file, rec);

    if ( adb_tr_first(tnx, file, &tr, &rec))
      printf("Can't find 1st!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find 1st: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);    
      }
/*     for ( j = 0 ; ! adb_prev(tnx, file, &tr, &rec ) ; ++j ) */
/*       { */
/* 	adb_fld_get(file, rec, "vstr", &s , NULL ); */
/* 	printf("Prev: %s\n",s); */
/*       } */
/*     printf("Got %d records backward\n",j); */
    

    if ( adb_tr_last(tnx, file, &tr, &rec))
      printf("Can't find last!!!\a\n");
    else
      {
	adb_fld_get(file, rec, "vstr", &s , NULL );
	printf("Find last: %s\n",s);
	/* traverser was initialized by adb_tr_first() */
	adb_tr_free(&tr);
      }
    adb_tnx_end(&tnx);
  }

 adb_stop("mvol0.db");

 return 0 ;
}

int
adb_test_create_files(adb_db_t *db, int endless)
{
  int i , j ;
  char *fn = NULL ;
  adb_meta_file_t *mfile ;
  adb_meta_open(db);

  do
    {
      for ( i = 0 ; i < 500 ; ++i )
	{
	  asprintf(&fn,"file%d",i);
	  mfile = adb_create_file(db, fn, 0);
	  free(fn) ; fn = NULL ;
	  for ( j = 0 ; mfile && j < 100 ; ++j )
	    {
	      asprintf(&fn,"field %d of file %d",j,i);
	      adb_create_field(db, mfile, fn, ADB_FIELD_INT, 0, EOF);
	      free(fn) ; fn = NULL ;
	    }
	}
	mfile = adb_create_file(db, "whee", 0);	
	adb_create_field(db, mfile, "a", ADB_FIELD_INT, 0 , EOF );
	adb_create_field(db, mfile, "b", ADB_FIELD_INT, 0 , 1 );
	adb_create_field(db, mfile, "c", ADB_FIELD_INT, 0 , 0 );
    }  
  while ( endless-- );

  adb_meta_commit(db);

  adb_show_files(db);

  return 0 ; 
}

int
adb_insert_test(adb_db_t *db)
{
  int a = 0 , b = 10 , c = 20 ;
  int i ;
  adb_tnx_t *tnx = adb_tnx_new();
  int fail = 0 ;
  adb_rec_t *r ;
  adb_file_t *file ;

  file = adb_file_open(db, "whee");
  assert(file != NULL );

  for ( i = 0 ; i < 10000000 ; ++i )
    {
      r = adb_insert_by_name(tnx , file , 
			     "a", a++ ,
			     "b", b++,
			     "c", c++,
			     NULL );
      if ( r == NULL ) ++fail ;
    }
  adb_tnx_end(&tnx);
  printf("Inserted %d failed %d\n",i,fail);
  return 0 ;
}

int
adb_random_insert_test(adb_db_t *db, char *filename)
{
  int a = 0 , b = 10 , c = 20 ;
  int i ;
  adb_tnx_t *tnx = adb_tnx_new();
  adb_file_t *file ;
  adb_rec_t *r ;
  int fail = 0 ;

  file = adb_file_open(db, filename);
  assert(file != NULL );

  srand (time (0));

/*   Adb_debug = ADB_DEBUG_RANGE_CMP ; */

  for ( i = 0 ; i < 1000000 ; ++i )
    {
      a = rand() % 100000;
      b = rand() % 100000;
      c = rand() % 10000000 ;
      
      r = adb_insert_by_name(tnx , file , 
			     "a", a,
			     "b", b,
			     "c", c,
			     NULL );
      if ( r == NULL ) ++fail ;
    }
  adb_tnx_end(&tnx);
  printf("Inserted %d failed %d\n",i,fail);
  return 0 ;
}

void
Adb__bench(void *a, void *param UNUSED )
{
  adb_rec_t *r = (adb_rec_t *) a ;
/*   adb_walk_t *w = (adb_walk_t *) param ; */
  
  assert( r->magic == ADB_MAGIC_RECORD );
}

void
adb_bench(adb_db_t *db, char *filename)
{
  adb_tnx_t *tnx = adb_tnx_new();
  adb_file_t *file ;
  
  file = adb_file_open(db, filename);
  assert(file);
  
  adb_walk( tnx, file, Adb__bench , NULL );

  adb_tnx_end(&tnx);	    
  return ;
}

int
adb_walk_test(adb_db_t *db, char *filename)
{
  adb_tnx_t *tnx = adb_tnx_new();
  adb_file_t *file ;

  file = adb_file_open(db, filename);
  assert(file);

  Adb_debug = ADB_DEBUG_MISC ;
  adb_walk( tnx, file, NULL , NULL );

  adb_tnx_end(&tnx);	    
  return 0 ;
}

int
adb_read_test(adb_db_t *db)
{
#if 0
  int a = 0 , b = 10 , c = 20 ;
  int i ;
#endif
  adb_tnx_t *tnx = adb_tnx_new();
/*   adb_ta_t *ta = NULL ; */
  adb_file_t *file ;

  file = adb_file_open(db, "whee");
  assert(file);
#if 0
  for ( i = 0 ; ; ++i )
    {
      if ( adb_next_by_name(tnx , bh, file , 
			    "a", &a ,
			    "b", &b ,
			    "c", &c ,
			    NULL ))
	{
	  /* TODO tnx rollback */
	  break ;
	}
    }
  fprintf(stderr, "Got %d records , last %d %d %d\n", i, a, b, c);
#endif /* 0 */
  adb_tnx_end(&tnx);
  return 0 ;
}

/* static int init_flag , random_insert_flag = 0 ; */

#include <argp.h>
     
const char *argp_program_version = PACKAGE "-" VERSION ;
const char *argp_program_bug_address = "<bug-adb@mef.cz>";
     
/* Program documentation. */
static char doc[] =
"adb example #0 -- a test program \
     \
     \vThis is free software; see the source for copying conditions.\
There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\
PARTICULAR PURPOSE." ;

/* A description of the arguments we accept. */
static char args_doc[] = "FILE DATABASE";
     
/* Keys for options without short-options. */
#define OPT_ABORT  1            /* -abort */

#define OPT_DUMP_TEST  0x1000 
#define OPT_LOCK_TEST  0x1001 
#define OPT_RANGE_SHOW 0x1002
#define OPT_BLOB_TEST  0x1003
#define OPT_LINK_BLOB  0x1004
#define OPT_I18N_TEST  0x1005
#define OPT_FIND_C_TEST 0x1006
#define OPT_FIND_W_TEST 0x1007

/* The options we understand. */
static struct argp_option options[] = {
  {0,0,0,0, "Miscelanous options" , 4},
  {"verbose",  'v', 0,       0, "Produce verbose output" , 0},
  {"quiet",    'q', 0,       0, "Don't produce any output", 0 },
/*   {"silent",   's', 0,       OPTION_ALIAS , 0 , 0}, */
  {"output",   'o', "FILE",  0,
   "Output to FILE instead of standard output" , 0 },
     
  {0,0,0,0, "Various tests" , 10},
  {"random-test",   'r', 0, 0, "Random insert test 10^6 records - to make VM unhappy and database blocks 51% full", 0 },
  {"init-test",     'i', 0, 0, "Fill meta data with ~50k files and 10^7 records in one file", 0 },
  {"types-test",    't', 0, 0, "Create \"complicated\" file", 0 } ,
  {"mvol-test",    'm', 0, 0, "Create \"complicated\" file in multivolume and plain DB", 0 } ,
  {"undo-test",    'u', 0, 0, "Create \"complicated\" file in multivolume and plain DB, try UNDO and watch disaster", 0 } ,
  {"sidx-test",    's', 0, 0, "Secondary index in multivolume and plain DB", 0 } ,
  {"link-test",    'l', 0, 0, "Link ( object references or whatever ) in various DBs", 0 } ,
  {"link-blob-test",  OPT_LINK_BLOB, 0, 0, "Link read ( ^^^ should run first )", 0 } ,
  {"i18n-test",  OPT_I18N_TEST, 0, 0, "Internationalisation, collating etc.", 0 } ,
  {"walk-test",     'w', 0, 0, "Walk test", 0 } ,
  {"bench",     'B', 0, 0, "Walk test - zero output", 0 } ,
  {"dump-test",     OPT_DUMP_TEST, 0, 0, "Dump table whee to /tmp/whee.cvs", 0 } ,
  {"lock-test",     OPT_LOCK_TEST, 0, 0, "Locking test", 0 } ,
  {"lock-read",     'R', 0, 0, "Locking test", 0 } ,
  {"lock-write",     'W', 0, 0, "Locking test", 0 } ,
  {"blob-test",     OPT_BLOB_TEST, 0, 0, "Blobs test, grabs /usr/src/*gz and infamously insert to file blob", 0 } ,
  {"find-create",     OPT_FIND_C_TEST, 0, 0, "Find create test ( needed for find-where )", 0 } ,
  {"find-where",     OPT_FIND_W_TEST, 0, 0, "Find first where test ( data created by find-create )", 0 } ,
  {"abort",    OPT_ABORT, 0, 0, "Abort before showing any output", 0},
  {"show-range", OPT_RANGE_SHOW,0,0,"Show ranges", 0},
  { 0,0,0,0,0,0 }
} ;
     
/* Used by `main' to communicate with `parse_opt'. */
struct arguments
{
/*   struct adb_arguments child ; */
  char *dbname ;
  int silent, verbose, abort;   /* `-s', `-v', `--abort' */
  char *output_file;            /* FILE arg to `--output' */
  int init_test , random_test , types_test , walk_test , bench , dump_test , lock_test ;
  int lock_write_test, lock_read_test  , blob_test , mvol_test , idx_test ;
  int link_test , link_blob_test, undo_test , i18n_test ;
  int find_create , find_where ;
  int adb_range_show_test ;
  char *file ;
};


#define START_N_STOP "You are trying to make me mad ? Aren't you ?!?!"

/* Parse a single option. */
static error_t
parse_opt (int key, char *arg, struct argp_state *state)
{
  /* Get the `input' argument from `argp_parse', which we
     know is a pointer to our arguments structure. */
  struct arguments *arguments = state->input;

  switch (key)
    {
    case OPT_FIND_C_TEST:
      arguments->find_create = 1 ;
      break ;
    case OPT_FIND_W_TEST:
      arguments->find_where = 1 ;
      break ;
    case OPT_BLOB_TEST:
      arguments->blob_test = 1 ;
      break ;
    case OPT_RANGE_SHOW:
      arguments->adb_range_show_test = 1 ;
      break ;
    case ARGP_KEY_FINI:
    case ARGP_KEY_END:
      break ;
    case OPT_DUMP_TEST:
      arguments->dump_test = 1 ;
      break ;
    case OPT_LOCK_TEST:
      arguments->lock_test = 1 ;
      break ;
    case OPT_LINK_BLOB:
      arguments->link_blob_test = 1 ;
      break ;
    case OPT_I18N_TEST:
      arguments->i18n_test = 1 ;
      break ;
    case 'R':
      arguments->lock_read_test = 1 ;
      break ; 
    case 'W':
      arguments->lock_write_test = 1 ;
      break ; 
    case 'B':
      arguments->bench = 1;
      break;
    case 'q': 
      arguments->silent = 1;
      break;
    case 'v':
      arguments->verbose = 1;
      break;
    case 'o':
      arguments->output_file = arg;
      break;
    case 'r':
/*       arguments->repeat_count = arg ? atoi (arg) : 10; */
      arguments->random_test = 1 ;
      break;
    case 'w':
      arguments->walk_test = 1 ;
      break ;
    case 'u':
      arguments->undo_test = 1 ;
      break ;
    case 't':
      arguments->types_test = 1 ;
      break ;
    case 'm':
      arguments->mvol_test = 1 ;
      break ;
    case 's':
      arguments->idx_test = 1 ;
      break ;
    case 'l':
      arguments->link_test = 1 ;
      break ;
    case 'i':
      arguments->init_test = 1 ;
      break ;
    case OPT_ABORT:
      arguments->abort = 1;
      break;
     
    case ARGP_KEY_NO_ARGS:
      argp_usage (state);
     
    case ARGP_KEY_ARG:
      /* Here we know that `state->arg_num == 0', since we
	 force argument parsing to end before any more arguments can
	 get here. */
      if (state->arg_num >= 2)
	{
	/* Too many arguments. */
	  fprintf(stderr,"#args: %d\n",state->arg_num);
	  argp_usage (state);
	}

      switch ( state->arg_num )
	{
	case 0:
	  arguments->file = arg;
	  break ;
	case 1:
	  arguments->dbname = arg;
	  break ;
	default:
	  argp_usage (state);
	  break ;
	}
/*       arguments->dbname = arg;  */
     
      /* Now we consume all the rest of the arguments.
	 `state->next' is the index in `state->argv' of the
	 next argument to be parsed, which is the first STRING
	 we're interested in, so we can just use
	 `&state->argv[state->next]' as the value for
	 arguments->strings.
     
	 *In addition*, by setting `state->next' to the end
	 of the arguments, we can force argp to stop parsing here and
	 return. */
/*       arguments->strings = &state->argv[state->next]; */
/*       state->next = state->argc; */
     
      break;
     
    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}
     
/* Our argp parser. */
static struct argp argp = { options, &parse_opt, args_doc, doc , 0,/* adb_argp_child, */ 0, 0};

struct arguments arguments;

int
main(int argc, char **argv)
{
  size_t page_size = (size_t) sysconf (_SC_PAGESIZE);
  adb_db_t *db ;

  /* Default values. */
  arguments.silent = 0;
  arguments.verbose = 0;
  arguments.output_file = "-";
  arguments.random_test = 0;
  arguments.abort = 0;
  /* Parse our arguments; every option seen by `parse_opt' will be
     reflected in `arguments'. */
  argp_parse (&argp, argc, argv, 0, 0, &arguments);
     
/*   if (arguments.abort) */
/*     error (10, 0, "ABORTED"); */

  printf("page size: %d\n",page_size);
  printf("sizeof off_t %d\n",sizeof(off_t));

  if ( ( locale = setlocale(LC_ALL, "")) == NULL )
    ADB_ERROR("setlocale failed");
  else
    {
      codeset = nl_langinfo(CODESET);
      ADB_WARNING("locale is: %s, codeset: %s\n", locale, codeset);
    }


  db = adb_open( arguments.dbname , TRUE);


  if ( arguments.init_test )
    {
      adb_test_create_files(db, 0); 

/*   adb_show_files(adb_sb); */

      adb_insert_test(db); 
      adb_walk_test(db, arguments.file);
    }

  if ( arguments.random_test )
    {
      adb_random_insert_test(db, arguments.file); 
      adb_walk_test(db, arguments.file);
    }

  if ( arguments.types_test )
    {
/*       adb_walk_test(TYPES);       */
/*       printf("sleep(30)\n"); sleep(30); */
      adb_types_test(db, arguments.file);
      adb_walk_test(db, arguments.file);
    }

  if ( arguments.mvol_test )
    {
/*       adb_walk_test(TYPES);       */
/*       printf("sleep(30)\n"); sleep(30); */
      adb_mvol_test(db, arguments.file);
      adb_walk_test(db, arguments.file);
    }

  if ( arguments.idx_test )
    {
      adb_idx_test(db, arguments.file);
      adb_walk_test(db, arguments.file);
    }

  if ( arguments.link_test )
    {
      adb_link_test(db, arguments.file);
      adb_walk_test(db, arguments.file);
    }

  
  if ( arguments.walk_test )
    {
      adb_walk_test(db, arguments.file);
    }
/*   adb_read_test(); */

  if ( arguments.bench )
    {
      adb_bench(db, arguments.file);
    }

  if ( arguments.dump_test )
    {
      adb_dump(db, arguments.file, "/tmp/dump.csv" );
    }

  if ( arguments.lock_test )
    {
      adb_lock_test(db, arguments.file, 10, 1);
    }

  if ( arguments.lock_read_test )
    _adb_lock_read_test(db, arguments.file);

  if ( arguments.lock_write_test )
    _adb_lock_write_test(db, arguments.file);

  if ( arguments.adb_range_show_test )
    adb_range_show_test(db, arguments.file);

  if ( arguments.blob_test )
    adb_blob_test(db, arguments.file);

  if ( arguments.link_blob_test )
    adb_link_blob_test(db, arguments.file);

  if ( arguments.undo_test )
    {
      adb_mvol_undo_test(db, arguments.file);
      adb_walk_test(db, arguments.file);
    }    

  if ( arguments.i18n_test )
    {
      adb_i18n_test(db, arguments.file);
/*       adb_walk_test(db, arguments.file); */
    }

  if ( arguments.find_create )
    adb_find_create_test(db, arguments.file);

  if ( arguments.find_where )
    adb_find_where_test(db, arguments.file);

  adb_close(db);
  exit( 0 ) ; 
}
