/* static int init_flag , random_insert_flag = 0 ; */
#define  __ADB_OPTIONS

#define  __ADB 1
#include "adb.h"
     
const char *argp_program_version = PACKAGE "-" VERSION ;
const char *argp_program_bug_address = "<bug-adb@mef.cz>";
     
/* Program documentation. */
static char adb_doc[] =
"\v" PACKAGE "-" VERSION " The pre-alpha database library\n\n\
     \
     This is free software; see the source for copying conditions.\
There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\
PARTICULAR PURPOSE." ;

/* A description of the arguments we accept. */
static char adb_args_doc[] = "DATABASE";
/* static char adb_args_doc[] = "ARG1 [STRING...]"; */
     
/* Keys for options without short-options. */

/* Used by `main' to communicate with `parse_opt'. */
typedef struct adb_arguments
{
  char *dbname ;                   /* ARG1 */
  int start , stop , redo, init , ai , bi , lock , single ;
  unsigned int base ;
  int dump_data , dump_scheme , load_data , load_scheme ;
  char *bi_dir , *ai_dir , *ai_file ;
} adb_arguments_t ;

struct adb_arguments adb_arguments =
  {
    .dbname = NULL, 
    .start = 0, .stop = 0, .redo = 0, .init = 0, .ai = 0, .bi = 0, 
    .lock = 0, .single = 0,
    .base = 0x30000000,
    .dump_data = 0, .dump_scheme = 0, .load_data = 0, .load_scheme = 0,
    .bi_dir = NULL, .ai_dir = NULL, .ai_file = NULL
  } ;

#define OPT_START 0x100 /* "server" */
#define OPT_STOP  0x101 /* shutdown */
/* 0x102 */
#define OPT_AI_FILE 0x103
#define OPT_AI_DIR 0x104
#define OPT_AI_OFF 0x105
#define OPT_BI    0x106
#define OPT_BI_OFF 0x107
#define OPT_INIT  0x108
#define OPT_BASE  0x109 /* ADB_SB_BASE 0x30000000 in earlier versions */
#define OPT_LOCK  0x110 /* use locking */
#define OPT_REDO  0x111

/* The options we understand. */
static struct argp_option adb_options[] = {
  {0,0,0,0, "General database operations" , 1},
  {"start",   OPT_START, 0, 0, "Start fake server, initialize multiuser IPC", 0},  
  {"stop",    OPT_STOP, 0, 0, "Stop fake server, remove IPC (TODO kill clients)", 0},  
/*   {"single",  '1', 0, 0, "Open database in single-user mode", 0},   */
  {0,0,0,0, "Following options should be used only with inactive database: with the --start option only",2},
  {"ai-file", OPT_AI_FILE, "AI-FILE", 0,
   "Start after-imaging on database ( redo logs in other slangs ) ", 0},  
  {"ai-dir", OPT_AI_DIR, "AI-DIR", 0, 
   "Set location of temporary after-image files and start after-imaging on database ( redo logs in other slangs )" , 0},  
  {"ai-off", OPT_AI_OFF, 0, 0, "Stop after-imaging on database", 0},
  {"bi",      OPT_BI, "BI-DIRECTORY", 0,
   "Start before-imaging on database ( undo logs in other slangs )", 0},  
  {"bi-off", OPT_BI_OFF, 0, 0, "Stop before-imaging on database", 0},
  {"redo" , OPT_REDO, "AI-FILE", OPTION_ARG_OPTIONAL, 
   "Apply transaction log in AI-FILE to database", 0},
/*   {"lock",      OPT_LOCK, "STATUS", OPTION_ARG_OPTIONAL, */
/*    "Start locking on database in multiuser mode, use \"--lock=no\" to stop this mode", 0},   */
  {0,0,0,0, "Database initialization" , 3},
/*   {"init",    OPT_INIT, 0, 0, "Initialize (remove if exists) empty database", 0},   */
  {"base",    OPT_BASE, "ADDR", 0, "Base address of database meta-schema ( 0x30000000 default ), to use multiple databases minimal safe distance of two bases is 32M e.g 0x02000000       !!!! DON'T USE !!!!", 0},  
  {0,0,0,0, "Maintenance options" , 4},
  {"dump", 'd', "DIRECTORY", OPTION_ARG_OPTIONAL, "Dump data, if no argument is given assuming `.' ", 0},
  {"load", 'l', "DIRECTORY", OPTION_ARG_OPTIONAL, "Load data, if no argument is given assuming `.' ", 0},
  {"dump-scheme",'D',"FILE",OPTION_ARG_OPTIONAL, "Dump content of meta-scheme, if no argument is given meta-scheme is dumped to database_name.df", 0},
  {"load-scheme",'L',"FILE",OPTION_ARG_OPTIONAL, "Load content of meta-scheme, if no argument is given meta-scheme is dumped to database_name.df", 0},
  { 0,0,0,0,0,0 }
} ;
     


static int
Adb_opt_to_int(char *arg)
{
  int v ;
  switch ( *arg )
    {
    case '1': case 'y':  case 'Y': v = 1 ;  break ;
    case '0': case 'n':  case 'N': v = -1 ; break ;
    default:  v = 0 ;  break ;
    }
  return v ;
}

#define START_N_STOP "You are trying to make me mad ? Aren't you ?!?!"

/* Parse a single option. */
error_t
adb_parse_opt (int key, char *arg, struct argp_state *state)
{
  /* Get the `input' argument from `argp_parse', which we
     know is a pointer to our arguments structure. */
  adb_arguments_t *arguments = state->input;
  int v ;

  switch (key)
    {
    case ARGP_KEY_INIT:
      break ;
    case OPT_START:
      if (arguments->stop )
	ADB_BUG(START_N_STOP) ;
      arguments->start = 1 ;
      break ;
    case OPT_STOP:
      if (arguments->start)
	ADB_BUG(START_N_STOP) ;
      arguments->stop = 1 ;
      break ;
    case OPT_INIT:
      arguments->init = 1 ;
      break ;
    case OPT_BASE:
      arguments->base = strtol(arg, NULL, 16);
      break ;
    case OPT_REDO:
      arguments->redo = TRUE ;
      if ( arg )
	arguments->ai_file = canonicalize_file_name(arg);
      break ;
    case OPT_AI_FILE:
      {
	char *a ;
	arguments->ai = TRUE ;
	if ( ( a = canonicalize_file_name(arg)))
	  arguments->ai_file = a ;
	else
	  arguments->ai_file = arg ;
      }
      break ;
    case OPT_AI_DIR:
      {
	char * a ;
	arguments->ai = TRUE ;
	Adb_mkdir(arg, 0777 );
	if ( ( a = canonicalize_file_name(arg) ))
	  arguments->ai_dir = a ;
	else
	  arguments->ai_dir = arg;
      }
      break ;
    case OPT_AI_OFF:
      arguments->ai = EOF ;
      break ;
    case OPT_BI:
      {
	char *b ;
	arguments->bi = TRUE ;
	Adb_mkdir(arg, 0777 );
	if ( ( b = canonicalize_file_name(arg)))
	  arguments->bi_dir = b ;
	else
	  arguments->bi_dir = arg ;
      }
      break ;
    case OPT_BI_OFF:
      arguments->bi = EOF ;
      break ;
    case OPT_LOCK:
      if ( arg ) v = Adb_opt_to_int(arg);
      else v = 1 ;
      arguments->lock = v ;
      break ;
    case '1':
      arguments->single = 1 ;
      break ;
    case 'd':
      arguments->dump_data = 1 ;
      break ;
    case 'l':
      arguments->load_data = 1 ;
      break ; 
    case 'D':
      arguments->dump_scheme = 1 ;
      break ;
    case 'L':
      arguments->load_scheme = 1;
      break ;
    case ARGP_KEY_NO_ARGS:
      argp_usage (state);
     
    case ARGP_KEY_ARG:
      /* Here we know that `state->arg_num == 0', since we
	 force argument parsing to end before any more arguments can
	 get here. */
      arguments->dbname = arg;
     
      /* Now we consume all the rest of the arguments.
	 `state->next' is the index in `state->argv' of the
	 next argument to be parsed, which is the first STRING
	 we're interested in, so we can just use
	 `&state->argv[state->next]' as the value for
	 arguments->strings.
     
	 *In addition*, by setting `state->next' to the end
	 of the arguments, we can force argp to stop parsing here and
	 return. */
#if 0
      arguments->strings = &state->argv[state->next];
      state->next = state->argc;
#endif     
      break;
     
    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}
     
/* Our argp parser. */
/* struct argp adb_argp = { options, parse_opt, args_doc, doc , 0, 0, 0}; */


struct argp adb_argp = { adb_options, &adb_parse_opt, adb_args_doc, adb_doc , 0, 0, 0};

#if 0
struct argp_child adb_argp_child[] = 
  {
    { &adb_argp, 0, PACKAGE " library options" , 0 },
    { NULL, 0, NULL, 0} ,
  } ;
#endif /* 0 */





int
main(int argc, char **argv)
{
  adb_db_t *db ;
  char *bi = NULL ;
  
  argp_parse (&adb_argp, argc, argv, 0, 0, &adb_arguments);

  if ( adb_arguments.redo == TRUE )
    {
      char *ai = NULL ;
      db = adb_start_db_single( adb_arguments.dbname , NULL );

      if ( adb_arguments.ai_file )
	ai = adb_arguments.ai_file ;
      
      adb_tnx_apply_ai(db, ai );
      adb_sweep(db);
      exit(0);
    }  


  if ( adb_arguments.start )
    {
      db = adb_start_db_multi( adb_arguments.dbname, NULL );

/*       db = adb_open( dbname , TRUE ); */
      if ( adb_arguments.bi == TRUE )
	{
	  if ( ! adb_arguments.bi_dir )
	    {
	      char *db = canonicalize_file_name(adb_arguments.dbname);
	      asprintf(&bi,"%s/bi/",db);
	    }
	  else
	    bi = adb_arguments.bi_dir ;
	  
	  adb_bi_start(db, bi);

	}

      if ( adb_arguments.ai == TRUE )
	{
	  if ( adb_arguments.ai_dir && adb_arguments.ai_file )
	    {
	      adb_ai_start(db, adb_arguments.ai_file,  adb_arguments.ai_dir);
	    }
	  else 
	    {
	      if ( adb_arguments.ai_dir )
		{
		  char *ai_file = NULL ;
		  asprintf(&ai_file, "%s/%s.ai", adb_arguments.ai_dir, db->nick );
		  adb_ai_start(db, ai_file,  adb_arguments.ai_dir);
		}
	      else if ( adb_arguments.ai_file )
		{
		  char *ai_dir = strdup( adb_arguments.ai_file );
		  char *slash ;
		  if ( ! ( slash = strrchr(ai_dir, '/')))
		    ADB_WARNING("No slash `/' found in canonicalized name `%s'\n",
				ai_dir );
		  else
		    {
		      *slash = 0 ;
		      adb_ai_start(db, adb_arguments.ai_file, ai_dir );
		      free( ai_dir );
		    }
		}
	    }
	}
    
      if ( adb_arguments.ai == EOF )
	adb_ai_stop(db);

      if (  adb_arguments.bi == EOF )
	adb_bi_stop(db);
    } /* if start */

  
  if ( adb_arguments.stop )
    {
/*       db = adb_open( adb_arguments.dbname , TRUE); */
      adb_stop( adb_arguments.dbname); /* zap SHM && semaphore */
      exit(0);
    }
  return 0 ;
}




