/* AVLDB - AVL DataBase library, BLOB

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#define  __ADB 1
#include "adb.h"


adb_blob_t *
adb_blob_create(size_t size, adb_blob_flag_t flag, void *arg)
{
  adb_blob_t *blob = Malloc(sizeof(*blob));

  memset( blob, 0 , sizeof(*blob));

  blob->magic = ADB_MAGIC_BLOB ;
  blob->flag = flag ;
  blob->size = size ;
  blob->arg.FP = arg ;

  return blob ;
}

void adb_blob_free(adb_blob_t *blob)
{
  assert( blob->magic == ADB_MAGIC_BLOB );
  free(blob);
}

#if 0
static void
Adb_blob_alloc( adb_blob_t *blob)
{

}
#endif

static void
Adb_blob_insert_fd(adb_file_t *file, adb_blob_t *blob, int fd )
{
  struct stat sb ;
  int r ;
  off_t size ;
  size_t page_size = (size_t) sysconf (_SC_PAGESIZE), n ;
  unsigned char page[page_size] ;

  if ( fstat(fd, &sb ))
    {
      g_warning("Can't stat");
      
      return ;
    }

  if ( ! sb.st_size  )
    {
      g_warning("Empty blob");
      return ;
    }

  size = ( sb.st_size / page_size + 1 ) * page_size ;
  g_message("Blob size %lld ( %lld pages ) => %lld bytes",
	    sb.st_size, 
	    sb.st_size / page_size + 1,
	    size );

  blob->size = sb.st_size ;
  
  Adb_lock_claim_sb_with(file->db, ADB__LOCK_EXTEND);
  
  fstat(file->blob_fd, &sb ); /* database */
  blob->offset = sb.st_size ;

  adb_lock_claim( file, blob->offset, 0L, ADB_LOCK_SEG , ADB_LOCK_WRITE);

#ifdef USE_FTRUNCATE
  r = ftruncate(file->blob_fd, size + sb.st_size); assert( r != EOF);
#else
  r = lseek(file->blob_fd, size, SEEK_END); assert( r != EOF);
#endif /* 0 */  

  Adb_lock_free_sb_with(file->db, ADB__LOCK_EXTEND);

  r = lseek( file->blob_fd, blob->offset, SEEK_SET); assert( r != (off_t)-1);
  do
    {
      n = read(fd, page, page_size);
      write(file->blob_fd, page, n);
    } while ( n == page_size );  
}

void
Adb_blob_insert(adb_file_t *file, adb_rec_t *rec)
{
  int i ;
  adb_blob_t *blob ;
  int fd ;
  adb_field_t *fld ;
  unsigned int sb = file->db->addr ;

  for ( i = 0 ; i < file->meta->last_order ; ++i )
    {
      if ( (void *)file->order[i] + sb )
	{
	  fld = (void *)file->order[i] + sb ;
	  if ( fld->magic == ADB_MAGIC_FIELD )
	    {
	      switch ( fld->type )
		{
		case ADB_FIELD_BLOB:
		case ADB_FIELD_BLOB_STRING:
		  blob = (void *)rec + fld->offset ;

		  switch ( blob->flag )
		    {
		    case ADB_BLOB_FLAG_FP:
		      {
			FILE *FP ;
			FP = (FILE *)blob->arg.FP ;
			fd = fileno(FP);
			Adb_blob_insert_fd( file, blob, fd );
		      }
		      break ;
		    case ADB_BLOB_FLAG_FD:
		      fd = blob->arg.fd ;
		      Adb_blob_insert_fd( file, blob, fd );
		      break ;
		    case ADB_BLOB_FLAG_NAME:
		      {
			int fd ;
			if (( fd = open(blob->arg.name, O_RDONLY )) < 0 )
			  {
			    ADB_WARNING("Can't open %s",blob->arg.name);
			    return ;
			  }
			Adb_blob_insert_fd( file, blob, fd );
			close(fd);
		      }
		      break ;
		    default:
		      assert("huh?" == 0 );
		      break ;
		    }
		  break ;
		default:
		  break ;
		}
	    }
	}
    }

}
