/* AVLDB - AVL DataBase library, name functions

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#define  __ADB 1
#include "adb.h"


/* #undef HAVE_CANONICALIZE_FILE_NAME */

#if ! defined(HAVE_CANONICALIZE_FILE_NAME)
static char *
gnu_getcwd ()
{
  int size = 100;
  char *buffer = (char *) Malloc (size);

  while (1)
    {
      char *value = getcwd (buffer, size);
      if (value != 0)
	return buffer;
      size *= 2;
      free (buffer);
      buffer = (char *) Malloc (size);
    }
}
#endif /* HAVE_CANONICALIZE_FILE_NAME */
char *
Adb_name_db(char *dbname)
{
  char *fn = NULL ;

#if HAVE_CANONICALIZE_FILE_NAME  
  if ( (fn = canonicalize_file_name(dbname)) == NULL )
    {
      ADB_ERROR("Can't access path info of %s", dbname );
      exit(1);
    }
#else

  char *pwd ;
  if ( g_path_is_absolute(dbname)) /* absolute path */
    fn = dbname ;
  else
    {
      char *dir = g_dirname(dbname);
      
      if ( ! strcmp(".",dir) )
	{
	  pwd = gnu_getcwd();
	  asprintf(&fn,"%s/%s",pwd, dbname );
	  free(pwd);
	}
      else /* some ../../ ugliness */
	{
	  char *new ;
	  pwd = gnu_getcwd();
	  if ( chdir(dir) ) abort();
	  new = gnu_getcwd();
	  if ( chdir(pwd) ) abort();
	  asprintf(&fn,"%s/%s",new, dbname );
	  free(pwd);
	  free(new);
	}
    }
#endif /* 0 */
  return fn ;
}

char *
Adb_name_db_nick(char *_name, char **nptr)
{
  char *last_slash , *last_dot ;
  char *name = strdup(_name);

  *nptr = name ;

  if ( ! ( last_slash = strrchr(name, '/')) )
    return name ;

  last_slash++ ;

  if ( ! ( last_dot = strrchr(last_slash,'.')))
    return last_slash ;

  *last_dot = 0 ;

  return last_slash ;
}

char *
Adb_name(char *dbname, char *ext)
{
  char *db = canonicalize_file_name(dbname);
  char *dot , *slash ;

  char *lock = NULL ;

  if ( db )
    {
      dot = strrchr(db,'.');
      slash = strrchr(db,'/');

      if ( dot && slash && dot > slash  )
	{
	  *dot = 0 ;
	  asprintf(&lock, "%s.%s", db, ext);
	}
      else abort();
    }
  else /* non existent file */
    {
      db = strdup(dbname);
      dot = strrchr(db,'.');
      if ( dot )
	{
	  *dot = 0 ;
	  asprintf(&lock, "%s.%s", db, ext);
	}
      else abort(); 
    }

  free(db);
  return lock ;
}

static char *
Adb_name_xi(char *dbname, char *dir, char x, int pid)
{
  char *db = strdup(dbname);
  char *dot = strrchr(db,'.') , *slash = strrchr(db,'/');
  char *xi = NULL ;

  if ( dir && *dir )
    {
      if ( dot && dot > slash && slash ) /* /path/a/b/bugs.db */
	{
	  slash++ ;
	  *dot = 0 ;
	  if ( pid )
	    asprintf(&xi, "%s/%s.%ci-%d",dir, slash, x, getpid());
	  else
	    asprintf(&xi, "%s/%s.%ci",dir, slash, x);
	}
      else abort();
    }
  else
    {
      if ( dot && dot > slash && slash ) /* /path/a/b/bugs.db */
	{
	  *dot = 0 ;
	  if ( pid )
	    asprintf(&xi, "%s.%ci-%d",db, x, getpid());
	  else
	    asprintf(&xi, "%s.%ci",db,  x);
	}
      else abort();
    } 
  free(db);
  return xi ;
}

char *
Adb_name_bi(adb_db_t *db, char *dbname)
{
  return Adb_name_xi(dbname, db->sb->bi_dir, 'b', TRUE );
}

char *
Adb_name_ai(adb_db_t *db, char *dbname)
{
  return Adb_name_xi(dbname, db->sb->ai_file, 'a', FALSE);
}
