/* AVLDB - AVL DataBase library, block manipulation

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#define  __ADB 1
#include "adb.h"

/* 
 * AI/BI 
 *
 */

#if 0
typedef struct ADB_XI_BLOCK_HRD
{
  int magic ;
  size_t diff_size ; 
  off_t offset ; /* of block */
  off_t next_hdr ; /* of ADB_XI_BLOCK_HRD */
} adb_xi_block_hrd_t ;

static 
void Adb_diff(adb_tnx_t *tnx, int fd, adb_bh_t *old_bh, adb_bh_t *new_bh)
{
  unsigned char *n, *o, *p, *q;
  unsigned char *old = (void *)old_bh->m, *new = (void *)new_bh->m ;
  unsigned char *end = new + new_bh->m->size, *base , *b ;

  adb_xi_hdr_t h = { ADB_MAGIC_DIFF , 0 , 0 } ; /* 2nd header */
  adb_xi_block_hrd_t hdr = { ADB_MAGIC_XI_HDR, 0 , old_bh->offset, 0 };

  off_t off , new_off ;
  size_t bsize ;
  int ret ;

  off = lseek(fd, 0 , SEEK_END);
  if ( off % adb_page_size )
    {
      ADB_ERROR("AI/BI size %lld %% %d != 0 but %lld\n", off, adb_page_size, 
		off % adb_page_size );
    }

  /* extent file */
  new_off = lseek(fd, new_bh->m->size, SEEK_END);
  assert( new_off != EOF );
  
  base = mmap(NULL, new_bh->m->size, PROT_READ | PROT_WRITE, MAP_SHARED, fd, off);
  assert(base != (unsigned char *)EOF);
  
  b = base + sizeof(hdr);

  for ( n = new , o = old ; n < end ; )
    {
      if ( *n != *o )
	{
	  unsigned char *hp = b ;
	  
	  b += sizeof(h);
	  h.offset = n - new ;
	  /* find where diff ends */
	  for ( p = n , q = o ; p < end && *p != *q ; ++p, ++q )
	    *b++ = *p++ ;

	  h.size = p - n ;
	  assert(h.size);
	  /* secondary diff header */
	  memcpy(hp, &h, sizeof(h));

	  n = p ;
	  o = q ;
	}
      else
	{
	  ++n ; 
	  ++o ;
	}
    }
  
  hdr.diff_size = b - base ;
  bsize = (( hdr.diff_size / adb_page_size ) + 1 ) * adb_page_size ;
  hdr.next_hdr = off + bsize ;
  /* primary block diff header */
  memcpy(base, &hdr, sizeof(hdr));

  ret = msync(base, bsize, MS_SYNC ); assert(ret != EOF);
  
  ftruncate(fd, hdr.next_hdr); 
}
#endif /* 0 */

void
Adb_seg_init(adb_db_t *db, adb_bh_t *bh, unsigned char *base , size_t size , 
	      adb_magic_t content , 
	      int level, off_t parent_offset )
{
  adb_mm_t *m = ( adb_mm_t *)base ; 
  unsigned char *map = (void *) m + ADB_MAGIC_SIZE ;
  unsigned char *pool = (void *) m + ADB_MAGIC_SIZE + m->map_size ;
  int r ;
  bh->m = m ;

  m->magic = ADB_MAGIC_MM ;
  assert( size == ADB_SEG_SIZE );
  m->size = size /* - ( ADB_SEG_MAGIC_SIZE + ADB_SEG_MAP_SIZE ) */ ;
  m->map_size = ADB_SEG_MAP_SIZE; /* size / 256 - sizeof(*m) ; */
/*   m->map = (void *)m + ADB_SEG_MAGIC_SIZE ; */
/*   m->pool = (void *)m + ADB_SEG_MAGIC_SIZE + ADB_SEG_MAP_SIZE ; */

  memset( map, 0, m->map_size );
  r = msync( base ,ADB_SEG_MAP_SIZE, MS_SYNC ); assert( r != EOF );
  
  /* debug */
  memset( pool, 0 , m->size  - ( ADB_SEG_MAGIC_SIZE + ADB_SEG_MAP_SIZE )) ;
  r = msync( pool , m->size  - ( ADB_SEG_MAGIC_SIZE + ADB_SEG_MAP_SIZE ) , MS_SYNC );
  assert( r != EOF );

  if ( ! level )
    assert( content == ADB_MAGIC_TREE );
  else
    assert( content == ADB_MAGIC_RANGE );

  switch ( content )
    {
    case ADB_MAGIC_RANGE:
    case ADB_MAGIC_TREE:
      m->content = content ;
      m->level = level ;
      m->parent = parent_offset ;
      bh->tree = &m->tree ;
      bh->db = db ;
      adb_tavl_create( bh->tree );
      break ;
    default:
      ADB_ERROR("Invalid content 0x%x - database is probably damaged",content);
      break ;
    }

  fprintf(stderr,"Rel tree %p %d\n", &m->tree , m->tree.tavl_count );
  return ;
}

/*
 *    AI/BI is here !!!!!!!!!!!!!!!!!! 
 */

void
Adb_seg_xi(adb_bh_t *bh, adb_magic_t magic)
{
  unsigned long dest_len = sizeof(zbuf);
  adb_tnx_hdr_t *hdr = (void *)zbuf ;
  char *z = zbuf + sizeof(*hdr);
  int r ;

  assert(bh->state & ADB_TNX_DIRTY );

  hdr->magic = magic ; /* ADB_MAGIC_TNX_BI ; */
  hdr->type = ADB_TNX_TYPE_BLOCK ;
  hdr->nfd = bh->file->meta->nfd ;
  hdr->offset = bh->offset ;
  hdr->orig_size = ADB_SEG_SIZE ; /* => bh->size *FIXME* */

  compress2 (z, &dest_len, (char *)bh->m, 
	     ADB_SEG_SIZE /* => bh->size */ , 1);
  if ( Adb_debug & ADB_DEBUG_VM )
    {
      fprintf(stderr,"%s dest_len: %lu compress ratio %.2f\n",__func__, dest_len,
	       dest_len * 100.0 / (float) ADB_SEG_SIZE /* => bh->size  *FIXME* */ );
    }

  hdr->size = dest_len ;
/*   bh->zbuf = Malloc(dest_len); */
/*   memcpy(bh->zbuf, zbuf, dest_len); */
/*   bh->zsize = dest_len ; */
  switch ( magic )
    {
    case ADB_MAGIC_TNX_BI:
      r = write( bh->file->xip->bi_fd, zbuf, dest_len + sizeof(*hdr) );
      break ;
    case ADB_MAGIC_TNX_AI:
      r = write( bh->file->xip->ai_fd, zbuf, dest_len + sizeof(*hdr) );
      break ;
    default: 
      abort() ;
    }

  assert( r == dest_len + sizeof(*hdr));

  fprintf(stderr,"%s type: %d size: %lu #%lld\n", __func__, hdr->type, 
	  dest_len + sizeof(*hdr), 0LL/*  lseek(bh->file->bip->fd, 0, SEEK_SET) - r */ );
}

void
Adb_seg_bi_type(adb_tnx_type_t type, adb_file_t *file, off_t offset)
{
  adb_tnx_hdr_t hdr = { .magic = ADB_MAGIC_TNX_BI, 
			.type = type,
			.nfd = file->meta->nfd,
			.__meta = (void *)file->meta - file->db->addr  } ;
  int r ;
  if ( ! (file->db->sb->mode & ADB_MODE_BI ))
    return ;

  
  switch ( type )
    {
    case ADB_TNX_TYPE_FILE_TYPE:
      hdr.offset = file->meta->data_start_type ;
      break ;
    case ADB_TNX_TYPE_FILE_START:
      hdr.offset = file->meta->data_start ;
      break ;
    case ADB_TNX_TYPE_BLOCK_ADD:
      hdr.offset = offset ;
      hdr.orig_size = file->meta->block_size ;
      break ;
    case ADB_TNX_TYPE_BLOCK_DEL:
      hdr.offset = offset ;
      hdr.orig_size = file->meta->block_size ;
      break ;
    default:
      ADB_WARNING("Unexpected type %d\n",type);
      ADB_BUG("BI meltdown finished");
      break ;
    }
  
  r = write( file->xip->bi_fd, &hdr, sizeof(hdr) );
  assert( r == sizeof(hdr) );

  fprintf(stderr,"%s type: %d size: %d #%lld\n", __func__, hdr.type, 
	  sizeof(hdr), hdr.offset);
}

void
Adb_seg_ai_type(adb_tnx_type_t type, adb_file_t *file, off_t offset)
{
  adb_tnx_hdr_t hdr = { .magic = ADB_MAGIC_TNX_AI, 
			.type = type,
			.nfd = file->meta->nfd,
			.__meta = (void *)file->meta - file->db->addr  } ;
  int r ;
  if ( ! (file->db->sb->mode & ADB_MODE_AI ))
    return ;

  
  switch ( type )
    {
    case ADB_TNX_TYPE_FILE_TYPE:
      hdr.offset = file->meta->data_start_type ;
      break ;
    case ADB_TNX_TYPE_FILE_START:
      hdr.offset = file->meta->data_start ;
      break ;
    case ADB_TNX_TYPE_BLOCK_ADD:
      hdr.offset = offset ;
      hdr.orig_size = file->meta->block_size ;
      break ;
    case ADB_TNX_TYPE_BLOCK_DEL:
      hdr.offset = offset ;
      hdr.orig_size = file->meta->block_size ;
      break ;
    default:
      ADB_WARNING("Unexpected type %d\n",type);
      ADB_BUG("AI meltdown finished");
      break ;
    }
  
  r = write( file->xip->ai_fd, &hdr, sizeof(hdr) );
  assert( r == sizeof(hdr) );

  fprintf(stderr,"%s type: %d size: %d #%lld\n", __func__, hdr.type, 
	  sizeof(hdr), hdr.offset);
}

adb_bh_t *
Adb_seg_add(adb_tnx_t *tnx, adb_file_t *file, off_t *start, 
	     adb_magic_t content,  int level , off_t parent_offset )
{
  struct stat statbuf ;
  unsigned char *new ;
  adb_bh_t *bh ;
  int r ;

  if ( file->xip == NULL && file->db->sb->mode & ADB_MODE_BI )
    Adb_tnx_bi_open(tnx, file);

  Adb_lock_claim_sb_with(file->db, ADB__LOCK_EXTEND);

  r = fstat ( file->fd , &statbuf ); 
  assert(r == 0); /* fstat failed , really strange.... */

#ifdef USE_FTRUNCATE
  r = ftruncate(file->fd, file->meta->block_size + statbuf.st_size); assert( r != EOF);
#else
  r = lseek( file->fd, file->meta->block_size, SEEK_END);  assert( r != EOF);
#endif

   Adb_lock_free_sb_with(file->db, ADB__LOCK_EXTEND);

  new = mmap( NULL ,
	      file->meta->block_size ,
	      PROT_READ | PROT_WRITE ,
	      MAP_SHARED,
	      file->fd , statbuf.st_size );
  if ( new ==  (void *)EOF)
    ADB_BUG("mmap");

  fprintf(stderr,"(%s) new size %lld @ %p #%Ld parent #%Ld\n", 
	  __FUNCTION__, file->meta->block_size + statbuf.st_size, new, 
	  statbuf.st_size, parent_offset);

/*   memset( new , 0 , size ); */
  Adb_seg_bi_type(ADB_TNX_TYPE_BLOCK_ADD, file, statbuf.st_size);

  if ( start )
    {
      Adb_tnx_set_data_start(file, start, statbuf.st_size);
      /* *start = statbuf.st_size ; */
    }

  bh = Adb_tnx_add(tnx, file, ADB_TNX_DIRTY, new, file->meta->block_size, 
		    statbuf.st_size );
  
  switch ( content )
    {
    case ADB_MAGIC_TREE:
      bh->cmp = Adb_data_cmp ;
      break ;
    case ADB_MAGIC_RANGE:
      bh->cmp = Adb_range_cmp ;
      break ;
    default:
      assert("Huh? " == 0 );
      break ;
    }

  Adb_seg_init(file->db, bh, new, file->meta->block_size, content, 
		level, parent_offset);

  Adb_seg_ai_type(ADB_TNX_TYPE_BLOCK_ADD, file, statbuf.st_size);

  return bh ;
}

void
Adb_seg_dirty(adb_tnx_t *tnx, adb_bh_t *bh)
{
  int ret ;
  off_t offset = bh->offset ;
  void *old_m = bh->m ;

  if ( bh->file->xip == NULL && bh->file->db->sb->mode & ADB_MODE_BI )
    Adb_tnx_bi_open(tnx, bh->file);


  ret = munmap(bh->m, bh->size ); assert( !ret );

  ret = lseek( bh->file->fd, offset, SEEK_SET ); assert( ret != EOF );

  bh->m = mmap( bh->m ,
	      bh->size ,
	      PROT_READ | PROT_WRITE ,
	      MAP_SHARED | MAP_FIXED ,
	      bh->file->fd , offset );

  assert( old_m == bh->m );

  bh->state |= ADB_TNX_DIRTY ;

  if ( Adb_debug & ADB_DEBUG_VM )
    fprintf(stderr,"%s %p dirty: %s\n",__FUNCTION__, bh->m, 
	    bh->state & ADB_TNX_DIRTY ? "yes" : "no" );

  if ( bh->file->db->sb->mode & ADB_MODE_BI )
    Adb_seg_xi(bh, ADB_MAGIC_TNX_BI);
}

adb_bh_t *
Adb_seg_attach(adb_tnx_t *tnx,adb_file_t *file, off_t start,
		adb_tnx_state_t state )
{
  unsigned char *new ;
  adb_bh_t *bh ;

  int prot = PROT_READ ;
  int ret ;
/*   adb_avlt_tree *tree ; */

  ret = lseek( file->fd, start, SEEK_SET ); assert( ret != EOF );

  if ( state & ADB_TNX_DIRTY )
    prot |= PROT_WRITE ;
  
  new = mmap( NULL ,
	      file->meta->block_size ,
	      prot ,
	      MAP_SHARED,
	      file->fd , start );
  if ( new == (void *)EOF )
    ADB_ERROR("Can't mmap at offset %lld",start);
  
  
/*   memset( new , 0 , size ); */

  bh = Adb_tnx_add(tnx, file, state, new, file->meta->block_size, start);

  /* WHY!?!?!? */
/*   ta->m = ( adb_mm_t *) Malloc(sizeof(*ta->m)); */
/*   memcpy( ta->m , new , sizeof(*ta->m)); */
/*   ta->m->map = new  + ADB_SEG_MAGIC_SIZE ; */
/*   ta->m->pool = new + ADB_SEG_MAGIC_SIZE + ADB_SEG_MAP_SIZE ; */

  bh->m = (adb_mm_t *)new ;
  bh->tree = &bh->m->tree ;
  bh->db = file->db ;
  bh->state = state ;

/*   tree = (void *)new_mm->tree + SEG(bh->addr) ; */

/*   tree->param = ta ; */ /* if segment is mapped RO => SEGV , silly ... */

  assert( bh->m->magic == ADB_MAGIC_MM );

  switch ( bh->m->content )
    {
    case ADB_MAGIC_RANGE:
      bh->cmp = Adb_range_cmp ;
      break ;
    case ADB_MAGIC_TREE:
      /* DEBUG */
      bh->cmp = Adb_data_cmp ;
/*       Adb_check_bh(bh, __FUNCTION__); */
      break ;
     default:
       break ;
     }
  if ( Adb_debug & ADB_DEBUG_VM )
    fprintf(stderr,"%s %p dirty: %s\n",__FUNCTION__, bh->m, 
	    prot & PROT_WRITE ? "yes" : "no" );
  
  if ( prot & PROT_WRITE && bh->file->db->sb->mode & ADB_MODE_BI )
     Adb_seg_xi(bh, ADB_MAGIC_TNX_BI);

  return bh ;
}

/* returns RO segments !!! */
adb_bh_t *
Adb_bh_find(adb_tnx_t *tnx, adb_file_t *file, off_t offset )
{
  adb_bh_t *bh , tmp ;

  adb_tnx_file_segs_t *fts ;

  tmp.offset = offset ;
  tmp.magic = ADB_MAGIC_BH ;

  if ( (fts = Adb_find_file_in_tnx(tnx, file )) == NULL ) /* no file now */
    {
/*       ADB_ERROR("file \"%s\" not found in TNX",file->name); */
      return (adb_bh_t *)NULL ;
    }

  bh = tavl_find( fts->atoms,  Adb_tnx_offset_cmp, &tmp );

/*   if ( ta == NULL ) */
/*     ADB_ERROR("offset %Ld , file \"%s\" not found in TNX",tmp.offset, file->name); */

  return bh ;

}

adb_bh_t *
Adb_seg_load(adb_tnx_t *tnx,adb_file_t *file, off_t offset,
	      adb_tnx_state_t state)
{
  adb_bh_t *bh ;

  if ( ( bh = Adb_bh_find(tnx , file , offset ) ) != NULL )
    {
      if ( ( state & ADB_TNX_DIRTY ) && ! ( bh->state & ADB_TNX_DIRTY ))
	Adb_seg_dirty( tnx, bh );
      return bh ;
    }
  else
    return Adb_seg_attach(tnx, file, offset , state  );
}

void
Adb_seg_unload(adb_tnx_t *tnx, adb_bh_t *bh, int sync)
{
  int ret ;

/*   adb_bh_t *_bh = Adb_bh_find( tnx, file, bh->offset ); */ /* top bh */
  adb_tnx_file_segs_t *fts ;

  if ( (fts = Adb_find_file_in_tnx(tnx, bh->file)) == NULL ) /* no file now */
    {
      ADB_ERROR("File %s isn't in trasaction", bh->file->meta->name );
      return ;
    }
/*   assert(_bh != NULL); */ /* !existeing segment */
  tavl_delete( fts->atoms, Adb_tnx_offset_cmp, bh);
  if ( fts->atoms->tavl_count == 0 )
    {
      tavl_delete( tnx->files, Adb_tnx_file_id_cmp, fts );
      free( fts );
    }
  if ( sync && bh->state & ADB_TNX_DIRTY )
    {
      ret = msync( (void *)bh->addr , bh->size , MS_SYNC  );
      assert(ret != EOF );

      /* AI */
      if ( bh->file->db->sb->mode & ADB_MODE_AI )
	{
	  if ( bh->file->xip == NULL )
	    Adb_tnx_bi_open(tnx, bh->file);

	  Adb_seg_xi(bh, ADB_MAGIC_TNX_AI );
	}
    }
  assert( (void *)bh->addr == (void *)bh->m );
  ret = munmap( (void *)bh->addr, bh->size );
  assert ( ret == 0 );

  if ( Adb_debug & ADB_DEBUG_VM )
    fprintf(stderr,"%s %p dirty: %s\n",__FUNCTION__, bh->m, 
	     bh->state & ADB_TNX_DIRTY? "yes" : "no" );

  
  free( bh );
  return ;
}

