/* AVLDB - AVL DataBase library, misc

   Copyright (C) 2002,2003 Petr Silhavy <silhavy@mef.cz>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#define  __ADB 1
#include "adb.h"


/*  extern char *sys_errlist[] ; */
extern int errno ;

void
_fail(char *file,int line,char *fce,char *msg,char *opt,int exit_now)
{
  fprintf(stderr,"FAIL: %s:%d %s() %s [%s] - %s errno %d\n",
	  file,line,fce,
	  msg, opt ? opt : "" ,
	  sys_errlist[errno], errno );
  if ( exit_now )
    abort();
}


void *
Malloc(size_t size)
{
  void *r ;
  if ( ( r = malloc(size)) == NULL )
    ADB_BUG("malloc failed");
  return r ;
}

void *
Malloc0(size_t size)
{
  void *r = Malloc(size);
  memset(r, 0, size);
  return r ;
}
