#  xawale.tcl -- graphical interface to play the african game.
#  Copyright (C) 2006 Laurent Le Bot and Alain Le Bot.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
#  USA
#
#!/bin/bash
# start wish \
exec wish "$0" ${1+"$@"}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#             fenetre d'accueil avec le copyright
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc copyrightDialog {first} {
global BIN
set img [image create photo -file [file join $BIN copyright.gif]]
toplevel .copyright -borderwidth 1 -relief sunken
label .copyright.image -image $img
pack .copyright.image -side top -anchor nw
if {$first=="TRUE"} {wm overrideredirect .copyright 1}
wm geometry .copyright 503x289+300+250
focus .copyright
raise .copyright .
}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Initialisation
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc initGame {} {
global trou0 gain0 trou gain label
global level depth

      for {set i 0} {$i<12} {incr i} {
       set trou($i) 4
      }

      set gain(0) 0
      set gain(1) 0
      
      array set trou0 [array get trou]
      array set gain0 [array get gain]
      
      set depth [expr 7+$level]
      
      set label "RUN"
      set ok 0
      toplevel .choix -borderwidth 1 -relief sunken
      wm title .choix "Who begins?"
      radiobutton .choix.toi -text "Player begins"   -variable label -value "RUN"
      radiobutton .choix.moi -text "Computer begins" -variable label -value "BEG"
      button .choix.ok -text OK -command "set ok 1; destroy .choix; jouer 0 0 1 1"
      pack .choix.toi .choix.moi -side top -anchor w -padx 40 -pady 2m
      pack .choix.ok -side bottom -ipadx 10 -padx 3 -pady 3
      grab .choix
      focus .choix
      tkwait variable ok
      grab release .choix
      
}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#               Undo : retour un coup en arriere
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc undo {} {
global trou0 gain0 trou gain label
if {$label=="RUN"} {array set trou [array get trou0]; array set gain [array get gain0]; affichage}
}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Affichage
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc affichage {} {
global level
global trou gain label depth
global img idtrou idgain1 idgain2 idprof

for {set i 0} {$i<12} {incr i} {.cnv delete $idtrou($i)}

set idtrou(11)  [.cnv create image [expr 52+83*0] [expr 135] -image $img($trou(11))]
set idtrou(10)  [.cnv create image [expr 52+83*1] [expr 133] -image $img($trou(10))]
set idtrou(9)  [.cnv create image [expr 53+83*2] [expr 131] -image $img($trou(9))]
set idtrou(8)  [.cnv create image [expr 55+83*3] [expr 129] -image $img($trou(8))]
set idtrou(7)  [.cnv create image [expr 57+83*4] [expr 130] -image $img($trou(7))]
set idtrou(6)  [.cnv create image [expr 58+83*5] [expr 131] -image $img($trou(6))]
set idtrou(0)  [.cnv create image [expr 54+83*0] [expr 219] -image $img($trou(0))]
set idtrou(1)  [.cnv create image [expr 54+83*1] [expr 219] -image $img($trou(1))]
set idtrou(2)  [.cnv create image [expr 58+83*2] [expr 215] -image $img($trou(2))]
set idtrou(3)  [.cnv create image [expr 58+83*3] [expr 214] -image $img($trou(3))]
set idtrou(4)  [.cnv create image [expr 58+83*4] [expr 214] -image $img($trou(4))]
set idtrou(5)  [.cnv create image [expr 58+83*5] [expr 212] -image $img($trou(5))]

set idtrou(12)  [.cnv create image [expr 60+83*2] [expr 43] -image $img($gain(1))]
if {$gain(1)>9} {
set idtrou(13)  [.cnv create image [expr 63+83*3] [expr 45] -image $img([expr $gain(1)-9])]
} else {
set idtrou(13)  [.cnv create image [expr 63+83*3] [expr 45] -image $img(0)]
}
set idtrou(14)  [.cnv create image [expr 68+83*2] [expr 308] -image $img($gain(0))]
if {$gain(0)>9} {
set idtrou(15)  [.cnv create image [expr 68+83*3] [expr 305] -image $img([expr $gain(0)-9])]
} else {
set idtrou(15)  [.cnv create image [expr 68+83*3] [expr 305] -image $img(0)]
}

.cnv delete $idgain1
.cnv delete $idgain2
.cnv delete $idprof
set idgain1 [.cnv create text 58 10 -text "Computer gain $gain(1)"]
set idgain2 [.cnv create text 50 30 -text "Player gain $gain(0)"]
set idprof  [.cnv create text 32 50 -text "Depth $depth"]

# fin de partie
if {$label=="END"} {
  if {$gain(0)>$gain(1)} {
  tk_messageBox -message "Tu m'as bien gagn"
  } elseif {$gain(0)<$gain(1)} {
  tk_messageBox -message "Je t'ai bien gagn"
  } else {
  tk_messageBox -message "C'est mme score"
  }
}

}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Jouer
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc jouer {x y w h} {
global BIN JOUER
global level depth Tmin Tmax
global trou0 gain0 trou gain label

set ligne [format %.0f [expr floor(4*$y/$h)]]
set colon [format %.0f [expr floor(6*$x/$w)]]

if {$label=="BEG"} {
affichage
.cnv configure -cursor watch
update
set resultat [exec $JOUER \
 -b $trou(0)-$trou(1)-$trou(2)-$trou(3)-$trou(4)-$trou(5)-$trou(6)-$trou(7)-$trou(8)-$trou(9)-$trou(10)-$trou(11) \
 -o $gain(0)-$gain(1) -c 2 -d $depth -s -x]
.cnv configure -cursor top_left_arrow
scan $resultat "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
		gain(0) gain(1) mvt label
.cnv configure -cursor top_left_arrow
affichage
}

if {$ligne==2&$label=="RUN"} {

array set trou1 [array get trou]
array set gain1 [array get gain]
.cnv configure -cursor watch
update
set resultat [exec $JOUER \
-b $trou(0)-$trou(1)-$trou(2)-$trou(3)-$trou(4)-$trou(5)-$trou(6)-$trou(7)-$trou(8)-$trou(9)-$trou(10)-$trou(11) \
-o $gain(0)-$gain(1) -p [expr $colon+1] -s -x ]
scan $resultat "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
		gain(0) gain(1) mvt label
.cnv configure -cursor top_left_arrow
affichage
if {$label=="RUN"} {array set trou0 [array get trou1]; array set gain0 [array get gain1]}
if {$label=="ERR"} {set label "RUN"; return}
if {$label=="END"} {return}

set time0 [clock seconds]
.cnv configure -cursor watch
update
set resultat [exec $JOUER \
-b $trou(0)-$trou(1)-$trou(2)-$trou(3)-$trou(4)-$trou(5)-$trou(6)-$trou(7)-$trou(8)-$trou(9)-$trou(10)-$trou(11) \
-o $gain(0)-$gain(1) -c 2 -d $depth -s -x]
.cnv configure -cursor top_left_arrow
set time [expr [clock seconds]-$time0]
if {$time>$Tmax($level)} {incr depth -1}
if {$time<$Tmin($level)} {incr depth  1}
scan $resultat "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
		gain(0) gain(1) mvt label
affichage
}

}



#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Affiche le contenu d'un trou
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc contenu {x y w h} {
global level depth
global trou gain label

set ligne [format %.0f [expr floor(4*$y/$h)]]
set colon [format %.0f [expr floor(6*$x/$w)]]

if {$ligne==0&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$gain(1) stone(s)"]"
}

if {$ligne==1&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$trou([expr 11-$colon]) stone(s)"]"
}

if {$ligne==2&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$trou($colon) stone(s)"]"
}

if {$ligne==3&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$gain(0) stone(s)"]"
}


}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#               Choix d'un fichier a importer
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc importGame {} {
global PATH
set resu [tk_getOpenFile -parent . -title "Select file to import" -initialdir [file join $PATH]]
if {$resu!=""} {set file $resu} else {return 0}
set resu [tk_chooseDirectory -parent . -title "Select target CeReS project" -initialdir [file join $PATH]]
if {$resu!=""} {set PATH $resu; set PROJ [file tail $PATH]} else {return 0}
tk_messageBox -message "Emeline, installe ton programme ici. Import $file to $PROJ"
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#               Choix d'un fichier a sauver
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc saveGame {} {
global PATH
set resu [tk_getSaveFile -parent . -title "Select file to save" -initialdir [file join $PATH]]
if {$resu!=""} {set file $resu} else {return 0}
set resu [tk_chooseDirectory -parent . -title "Select target CeReS project" -initialdir [file join $PATH]]
if {$resu!=""} {set PATH $resu; set PROJ [file tail $PATH]} else {return 0}
tk_messageBox -message "Emeline, installe ton programme ici. Save $file to $PROJ"
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#               Affichage de la documentation
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc helpDialog {} {
global BIN
toplevel .rule -borderwidth 1 -relief sunken
set flagUK [image create photo -file [file join $BIN uk.gif]]
set flagFR [image create photo -file [file join $BIN fr.gif]]
frame .rule.flag
button .rule.flag.uk -image $flagUK -command textUK
button .rule.flag.fr -image $flagFR -command textFR
text .rule.txt -relief sunken -bd 2 -yscrollcommand ".rule.scroll set" -setgrid 1 \
 -height 30 -width 100 -spacing2 5;
scrollbar .rule.scroll -command ".rule.txt yview"
pack .rule.flag.uk -side left -padx 5 -pady 5
pack .rule.flag.fr -side left -padx 5 -pady 5
pack .rule.flag -side top -anchor w
pack .rule.scroll -side right -fill y
pack .rule.txt -expand yes -fill both
textUK
}


proc textFR {} {
.rule.txt delete 0.0 end
.rule.txt insert 0.0 \
{Rgles du jeu d'awal

Le jeu d'awal se dcompose en deux lignes de six trous. La ligne du haut est affecte  \
l'ordinateur tandis que la ligne du bas est affecte au joueur. Les autres trous servent  stocker \
les pierres "manges" au cours de la partie.

Chaque trou contient quatre pierres en dbut de partie.

Les joueurs jouent chacun leur tour. On ne peut pas jouer deux fois de suite. On ne peut pas sauter son tour.

Le joueur qui joue prend toutes les pierres de l'un de ses trous et les distribue une  une \
dans les trous suivants en tournant dans le sens anti-horaire. On ne pose pas de pierre \
dans le trou de dpart (ce cas de figure se prsente lorsque le joueur distribue plus de douze \
pierres).

On "mange" les pierres du dernier trou atteint lorsque celui se situe chez l'adversaire et contient deux ou trois pierres \
en comptant la dernire pierre pose. On "mange" aussi les trous conscutifs prcdents qui respectent \
cette condition. On ne peut pas "manger" plus de quatre trous conscutifs. Seuls les quatre derniers trous sont \
"mangs" lorsque cinq trous ou plus sont "mangeables".

Le joueur est tenu de fournir des pierres  l'adversaire losque celui-ci n'en possde plus. \
S'il ne peut pas fournir de pierres, la partie s'arrte.

Le joueur qui a "mang" le plus de pierres a gagn.
}
}

proc textUK {} {
.rule.txt delete 0.0 end
.rule.txt insert 0.0 \
{Rules of awale.

Awale game contains two lines of six holes. Each player plays a single line, the \
upper line for the computer and the lower line for the player. Other pair of holes \
are used for eaten stones.

Every holes contain four stones at the beginning of the game.

One plays alternately. One never play two turns, one cannot pass his turn.

When playing, take all the stones of a hole in your line and distribute it \
in successive holes turning counterclock wise, one stone per hole. Do not \
put a stone in the starting hole (this case arrives when the starting hole \
contains more than twelve stones.)

The stones of the arrival hole are eaten when the arrival hole lies in the \
opponent line and contains two or three stones (after all stones are distributed). \
All contiguous previous holes which meet this condition are also \
eaten. It is possible to eat a maximum of four holes, when five holes are \
eatable, only the last four ones are eaten.

Players have to play such that the opponent always has at least one stone. \
In case it is impossible, the game stops.

The winner is the player who has eaten the most stones.
}
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#               begin of main
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

switch $tcl_platform(platform) {
"unix"      {
    set JOUER awale
            }
"macintosh" {
    set JOUER awale
            }
"windows"   {
    set JOUER awale.exe
            }
}

set BIN [file dirname [info script]]
set HOME $env(HOME)
set PATH $HOME
set level 1
set prems 1
set label "END"
for {set i 0} {$i<12} {incr i} {set idtrou($i) 0}
set idgain1 0
set idgain2 0
set idprof 0
array set Tmin [list 1 1 2 3 3 15]
array set Tmax [list 1 5 2 20 3 100]

wm title . "Awale"

# creation du menu

menu .menu -tearoff 0

set m .menu.play
menu $m -tearoff 0
.menu add cascade -label "Play" -menu $m -underline 0
$m add command -label "New game" -command {initGame; affichage}
#$m add command -label "Import"   -command {importGame}
#$m add command -label "Save"     -command {saveGame}
$m add command -label "Undo"     -command {undo}
$m add command -label "Quit"     -command {destroy .}

set m .menu.level
menu $m -tearoff 0
.menu add cascade -label "Level" -menu $m -underline 0
$m add radio -label "1" -variable level -value 1
$m add radio -label "2" -variable level -value 2
$m add radio -label "3" -variable level -value 3

set m .menu.help
menu $m -tearoff 0
.menu add cascade -label "Help" -menu $m -underline 0
$m add command -label "Rules" -command {helpDialog}
$m add command -label "About" -command {copyrightDialog FALSE}

. configure -menu .menu


# creation de l'image centrale

set fond [image create photo -file [file join $BIN Awale.gif]]
set largeur [image width $fond]
set hauteur [image height $fond]
for {set i  0} {$i<10} {incr i} {set img($i) [image create photo -file [file join $BIN Trou0$i.gif]]}
for {set i 10} {$i<49} {incr i} {set img($i) [image create photo -file [file join $BIN Trou09.gif]]}

canvas .cnv -width $largeur -height $hauteur -cursor top_left_arrow
bind .cnv <ButtonPress-1> "jouer %x %y $largeur $hauteur"
bind .cnv <ButtonPress-3> "contenu %x %y $largeur $hauteur"
pack .cnv -side top -anchor nw

.cnv create image [expr $largeur/2] [expr $hauteur/2] -image $fond

# ecran d'acceuil

copyrightDialog TRUE
after 2000 {destroy .copyright}
