#  xawale.tcl -- graphical interface to play the african game.
#  Copyright (C) 2006 Laurent Le Bot and Alain Le Bot.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
#  USA
#
# Version 1.3 last modified on May 6th, 2008.
#
#!/bin/bash
# start wish \
exec wish "$0" ${1+"$@"}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                 Welcome window with copyright
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc copyrightDialog {first} {
global BIN
destroy .copyright
set img [image create photo -file [file join $BIN copyright.gif]]
toplevel .copyright -borderwidth 1 -relief sunken
label .copyright.image -image $img
pack .copyright.image -side top -anchor nw
if {$first=="TRUE"} {wm overrideredirect .copyright 1}
wm geometry .copyright 500x327+300+250
focus .copyright
raise .copyright .
}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Initialisation
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc initGame {} {
global trou gain label start
global level depth depth0
global turn iturn

      set label "RUN"

      for {set i 0} {$i<12} {incr i} {
       set trou($i) 4
      }

      set gain(0) 0
      set gain(1) 0

      set depth $depth0($level)

#      if {$start=="PLAYER"} {set label "RUN"} else {set label "BEG"}

      set iturn 0
      set turn(0) "board=4-4-4-4-4-4-4-4-4-4-4-4 score=0-0 move=0 $label"

      affichage NULL
      if {$start=="COMPUTER"} {jouer 0 1 1 4}

}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                     Chose a file to import
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc importGame {} {
global PATH LANG IFIL EFIL
global level depth start
global trou gain label
global turn iturn

set resu [tk_getOpenFile -parent . -title $IFIL($LANG) -initialdir [file join $PATH]]
if {$resu!=""} {set file $resu} else {return 0}
if {[catch {open $resu r} fid]} {tk_messageBox -message "$EFIL($LANG) $resu"; return}
set iturn -1
set depth [expr 7+$level]
while {[gets $fid turn([incr iturn])]>0} {
  scan $turn($iturn) "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
  gain(0) gain(1) mvt label
}
incr iturn -1
close $fid
affichage NULL
if {$start=="COMPUTER"&&$label=="RUN"} {jouer 0 1 1 4}
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                      Chose a file to save
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc saveGame {} {
global PATH LANG SFIL EFIL
global turn iturn
set resu [tk_getSaveFile -parent . -title $SFIL($LANG) -initialdir [file join $PATH]]
if {$resu!=""} {set file $resu} else {return 0}
if {[catch {open $resu w} fid]} {tk_messageBox -message "$EFIL($LANG) $resu"; return}
for {set jturn 0} {$jturn<=$iturn} {incr jturn} {puts $fid $turn($jturn)}
close $fid
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                     Open configure file
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc openConf {} {
global PATH LANG

if {![catch {open [file join ~ .xawale.ini] r} fid]} {
gets $fid line
scan $line "LANG=%2s" LANG
close $fid
}

}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                      Save configure file
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc saveConf {} {
global PATH LANG

if {![catch {open [file join ~ .xawale.ini] w} fid]} {
puts $fid LANG=$LANG
close $fid
}

}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                     Undo : cancel a turn
# Last modified 5 may 2008
# the line
#  if {$label=="RUN"&$iturn>=2} {
# has been replaced by
#  if {$iturn>=2} {
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc undo {} {
global trou gain label
global turn iturn
if {$iturn>=2} {
incr iturn -2
scan $turn($iturn) "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
                gain(0) gain(1) mvt label
affichage NULL
}
}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Display of the board
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc affichage {mvt} {
global LANG WIN LOSE DRAW CSCO PSCO P1CO P2CO DEPT TURN
global level
global trou gain label depth
global img idtrou indication
global turn iturn

set a 74
set b 83
# width of highlighted circle
set c 4

for {set i 0} {$i<12} {incr i} {.cnv delete $idtrou($i)}

set idtrou(11)  [.cnv create image [expr 52+$b*0] [expr 135] -image $img($trou(11))]
set idtrou(10)  [.cnv create image [expr 52+$b*1] [expr 133] -image $img($trou(10))]
set idtrou(9)   [.cnv create image [expr 53+$b*2] [expr 131] -image $img($trou(9))]
set idtrou(8)   [.cnv create image [expr 55+$b*3] [expr 129] -image $img($trou(8))]
set idtrou(7)   [.cnv create image [expr 57+$b*4] [expr 130] -image $img($trou(7))]
set idtrou(6)   [.cnv create image [expr 58+$b*5] [expr 131] -image $img($trou(6))]
set idtrou(0)   [.cnv create image [expr 54+$b*0] [expr 219] -image $img($trou(0))]
set idtrou(1)   [.cnv create image [expr 54+$b*1] [expr 219] -image $img($trou(1))]
set idtrou(2)   [.cnv create image [expr 58+$b*2] [expr 215] -image $img($trou(2))]
set idtrou(3)   [.cnv create image [expr 58+$b*3] [expr 214] -image $img($trou(3))]
set idtrou(4)   [.cnv create image [expr 58+$b*4] [expr 214] -image $img($trou(4))]
set idtrou(5)   [.cnv create image [expr 58+$b*5] [expr 212] -image $img($trou(5))]

set idtrou(12)  [.cnv create image [expr 60+$b*2] [expr 43] -image $img($gain(1))]
if {$gain(1)>9} {
set idtrou(13)  [.cnv create image [expr 63+$b*3] [expr 45] -image $img([expr $gain(1)-9])]
} else {
set idtrou(13)  [.cnv create image [expr 63+$b*3] [expr 45] -image $img(0)]
}
set idtrou(14)  [.cnv create image [expr 68+$b*2] [expr 308] -image $img($gain(0))]
if {$gain(0)>9} {
set idtrou(15)  [.cnv create image [expr 68+$b*3] [expr 305] -image $img([expr $gain(0)-9])]
} else {
set idtrou(15)  [.cnv create image [expr 68+$b*3] [expr 305] -image $img(0)]
}

.cnv delete $indication
if {$level=="2players"} {
   set indication [.cnv create text 70 30 \
   -text "$P1CO($LANG) $gain(1)\n$P2CO($LANG) $gain(0)\n$DEPT($LANG) $depth $TURN($LANG) $iturn"]
} else {
   set indication [.cnv create text 70 30 \
   -text "$CSCO($LANG) $gain(1)\n$PSCO($LANG) $gain(0)\n$DEPT($LANG) $depth $TURN($LANG) $iturn"]
}

# surlignagne du trou venant d'etre joue
if {$mvt=="12"} {
set mvtcircle [.cnv create oval [expr 15+$b*0] [expr 98] [expr 15+$b*0+$a] [expr 98+$a] -width $c] 
after 1000 ".cnv delete $mvtcircle"
}
if {$mvt=="11"} {
set mvtcircle [.cnv create oval [expr 15+$b*1] [expr 96] [expr 15+$b*1+$a] [expr 96+$a] -width $c] 
after 1000 ".cnv delete $mvtcircle"
}
if {$mvt=="10"} {
set mvtcircle [.cnv create oval [expr 16+$b*2] [expr 94] [expr 16+$b*2+$a] [expr 94+$a] -width $c] 
after 1000 ".cnv delete $mvtcircle"
}
if {$mvt=="9"} {
set mvtcircle [.cnv create oval [expr 18+$b*3] [expr 92] [expr 18+$b*3+$a] [expr 92+$a] -width $c] 
after 1000 ".cnv delete $mvtcircle"
}
if {$mvt=="8"} {
set mvtcircle [.cnv create oval [expr 20+$b*4] [expr 93] [expr 20+$b*4+$a] [expr 93+$a] -width $c] 
after 1000 ".cnv delete $mvtcircle"
}
if {$mvt=="7"} {
set mvtcircle [.cnv create oval [expr 21+$b*5] [expr 94] [expr 21+$b*5+$a] [expr 94+$a] -width $c] 
after 1000 ".cnv delete $mvtcircle"
}

update

# fin de partie
if {$label=="END"} {
  if {$gain(0)>$gain(1)} {
  tk_messageBox -message $LOSE($LANG)
  } elseif {$gain(0)<$gain(1)} {
  tk_messageBox -message $WIN($LANG)
  } else {
  tk_messageBox -message $DRAW($LANG)
  }
}

}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                        Play
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc jouer {x y w h} {
global BIN JOUER
global level depth Tmin Tmax nbeat noeat noall noatk
global trou gain label start
global turn iturn

set ligne [format %.0f [expr floor(4*$y/$h)]]
set colon [format %.0f [expr floor(6*$x/$w)]]
if {$ligne==1} {set trou0 [expr 12-$colon]}
if {$ligne==2} {set trou0 [expr $colon+1]}
if {$ligne!=1&$ligne!=2} {return}

.cnv configure -cursor watch
update

# player move
if {$level!="2players"&&$ligne==2&&$label=="RUN"||$level=="2players"&&$label=="RUN"} {

  set turn([incr iturn]) [exec $JOUER \
    -b $trou(0)-$trou(1)-$trou(2)-$trou(3)-$trou(4)-$trou(5)-$trou(6)-$trou(7)-$trou(8)-$trou(9)-$trou(10)-$trou(11) \
    -o $gain(0)-$gain(1) -p $trou0 -e $nbeat -sx$noeat$noall$noatk]
  scan $turn($iturn) "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
                gain(0) gain(1) mvt label
  if {[cyclic]==1&&$label!="ERR"} {set label "END"}
  if {$label=="ERR"} {incr iturn -1}
  affichage $mvt

}

# computer move
if {$level!="2players"&&$ligne==2&&$label=="RUN"||$level!="2players"&&$label=="RUN"&&$start=="COMPUTER"} {

  set time0 [clock seconds]
  set turn([incr iturn]) [exec $JOUER \
    -b $trou(0)-$trou(1)-$trou(2)-$trou(3)-$trou(4)-$trou(5)-$trou(6)-$trou(7)-$trou(8)-$trou(9)-$trou(10)-$trou(11) \
    -o $gain(0)-$gain(1) -c 2 -d $depth -e $nbeat -sx$noeat$noall$noatk]
  scan $turn($iturn) "board=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u score=%u-%u move=%u %6s" \
                trou(0) trou(1) trou(2) trou(3) trou(4) trou(5) \
                trou(6) trou(7) trou(8) trou(9) trou(10) trou(11) \
                gain(0) gain(1) mvt label
  set time [expr [clock seconds]-$time0]
  if {$time==0}            {after 1000}
  if {$time>$Tmax($level)} {incr depth -1}
  if {$time<$Tmin($level)} {incr depth  1}
  if {[cyclic]==1&&$label!="ERR"} {set label "END"}
  if {$label=="ERR"} {incr iturn -1}
  affichage $mvt

}

.cnv configure -cursor top_left_arrow
if {$label=="ERR"} {set label "RUN"}
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                        Cyclic
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc cyclic {} {
global trou gain label
global turn iturn

set n [string first " score" turn($iturn)]

for {set i 1} {$i<$iturn} {incr i} {
  if {[string compare -length $n $turn($i) $turn($iturn)]==0} {return 1}
}

return 0

}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                   Display the content of a hole
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc contenu {x y w h} {
global level depth
global trou gain label

set ligne [format %.0f [expr floor(4*$y/$h)]]
set colon [format %.0f [expr floor(6*$x/$w)]]

if {$ligne==0&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$gain(1) seed(s)"]"
}

if {$ligne==1&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$trou([expr 11-$colon]) seed(s)"]"
}

if {$ligne==2&$label=="RUN"} {
   after 1000 ".cnv delete [.cnv create text 38 70 -text "$trou($colon) seed(s)"]"
}

if {$ligne==3&$label=="RUN"} {
   after 2000 ".cnv delete [.cnv create text 38 70 -text "$gain(0) seed(s)"]"
}


}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                       Configure rules
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc configureRules {} {
global BIN LANG MAXI EATL EATN EATA NOAL ATKA NOAK YES NO OK DEFA DETA nbeat noeat noall noatk
destroy .configure
toplevel .configure -borderwidth 1 -relief sunken

labelframe .configure.frame1 -text $DETA($LANG) -labelanchor nw -padx 10 -borderwidth 2

frame  .configure.frame1.nbeat -borderwidth 10
label  .configure.frame1.nbeat.lbl -text $MAXI($LANG)
radiobutton .configure.frame1.nbeat.check1 -text "1" -variable nbeat -value "1"
radiobutton .configure.frame1.nbeat.check2 -text "2" -variable nbeat -value "2"
radiobutton .configure.frame1.nbeat.check3 -text "3" -variable nbeat -value "3"
radiobutton .configure.frame1.nbeat.check4 -text "4" -variable nbeat -value "4"
radiobutton .configure.frame1.nbeat.check5 -text "5" -variable nbeat -value "5"
radiobutton .configure.frame1.nbeat.check6 -text "6" -variable nbeat -value "6"
pack   .configure.frame1.nbeat.lbl -side left -anchor n
pack   .configure.frame1.nbeat.check1 -side left -anchor n
pack   .configure.frame1.nbeat.check2 -side left -anchor n
pack   .configure.frame1.nbeat.check3 -side left -anchor n
pack   .configure.frame1.nbeat.check4 -side left -anchor n
pack   .configure.frame1.nbeat.check5 -side left -anchor n
pack   .configure.frame1.nbeat.check6 -side left -anchor n

frame  .configure.frame1.eat -borderwidth 10
frame  .configure.frame1.eat.lbl
label  .configure.frame1.eat.lbl.1 -text $EATL($LANG)
label  .configure.frame1.eat.lbl.2 -text $EATN($LANG)
pack   .configure.frame1.eat.lbl.1 -side top -anchor w
pack   .configure.frame1.eat.lbl.2 -side top -anchor w

frame  .configure.frame1.eat.chk
radiobutton .configure.frame1.eat.chk.1 -variable noeat -value ""
radiobutton .configure.frame1.eat.chk.2 -variable noeat -value "m"
pack   .configure.frame1.eat.chk.1 -side top
pack   .configure.frame1.eat.chk.2 -side top

frame  .configure.frame1.all -borderwidth 10
frame  .configure.frame1.all.lbl
label  .configure.frame1.all.lbl.1 -text $EATA($LANG)
label  .configure.frame1.all.lbl.2 -text $NOAL($LANG)
pack   .configure.frame1.all.lbl.1 -side top -anchor w
pack   .configure.frame1.all.lbl.2 -side top -anchor w

frame  .configure.frame1.all.chk
radiobutton .configure.frame1.all.chk.1 -variable noall -value ""
radiobutton .configure.frame1.all.chk.2 -variable noall -value "a"
pack   .configure.frame1.all.chk.1 -side top
pack   .configure.frame1.all.chk.2 -side top

frame  .configure.frame1.atk -borderwidth 10
frame  .configure.frame1.atk.lbl
label  .configure.frame1.atk.lbl.1 -text $ATKA($LANG)
label  .configure.frame1.atk.lbl.2 -text $NOAK($LANG)
pack   .configure.frame1.atk.lbl.1 -side top -anchor w
pack   .configure.frame1.atk.lbl.2 -side top -anchor w

frame  .configure.frame1.atk.chk
radiobutton .configure.frame1.atk.chk.1 -variable noatk -value ""
radiobutton .configure.frame1.atk.chk.2 -variable noatk -value "k"
pack   .configure.frame1.atk.chk.1 -side top
pack   .configure.frame1.atk.chk.2 -side top

frame  .configure.button
button .configure.button.ok      -text $OK($LANG)   -command {destroy .configure}
button .configure.button.default -text $DEFA($LANG) -command {
                                                           global noeat nbeat noall noatk
                                                           set noeat ""
                                                           set nbeat 4
                                                           set noall ""
                                                           set noatk ""
                                                          }
#button .configure.button.cancel -text "CANCEL" -command {destroy .configure}
pack .configure.button.ok      -side left  -ipadx 18 -padx 5 -pady 5
pack .configure.button.default -side right -padx 5 -pady 5
#pack .configure.button.cancel -side right -padx 5 -pady 5


pack .configure.frame1         -side top
pack .configure.frame1.nbeat   -side top   -anchor w
pack .configure.frame1.eat     -side top   -anchor w
pack .configure.frame1.eat.lbl -side left  -anchor w
pack .configure.frame1.eat.chk -side left  -anchor w
pack .configure.frame1.all     -side top   -anchor w
pack .configure.frame1.all.lbl -side left  -anchor w
pack .configure.frame1.all.chk -side left  -anchor w
pack .configure.frame1.atk     -side top   -anchor w
pack .configure.frame1.atk.lbl -side left  -anchor w
pack .configure.frame1.atk.chk -side left  -anchor w
pack .configure.button -side bottom -anchor s

}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                          Display rule
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc helpDialog {} {
global BIN LANG
destroy .rule
toplevel .rule -borderwidth 1 -relief sunken
set flag_uk [image create photo -file [file join $BIN uk.gif]]
set flag_fr [image create photo -file [file join $BIN fr.gif]]
set flag_sp [image create photo -file [file join $BIN sp.gif]]
frame .rule.flag
button .rule.flag.uk -image $flag_uk -command rule_uk
button .rule.flag.fr -image $flag_fr -command rule_fr
button .rule.flag.sp -image $flag_sp -command rule_sp
text .rule.txt -relief sunken -bd 2 -yscrollcommand ".rule.scroll set" -setgrid 1 \
 -height 30 -width 100 -spacing2 5;
scrollbar .rule.scroll -command ".rule.txt yview"
pack .rule.flag.uk -side left -padx 5 -pady 5
pack .rule.flag.fr -side left -padx 5 -pady 5
pack .rule.flag.sp -side left -padx 5 -pady 5
pack .rule.flag -side top -anchor w
pack .rule.scroll -side right -fill y
pack .rule.txt -expand yes -fill both
rule_$LANG
}


proc rule_sp {} {
.rule.txt delete 0.0 end
.rule.txt insert 0.0 \
{Reglas del awale.

El juego del awale se compone de dos lneas de seis agujeros. La lnea de arriba se atribuye \
al ordenador mientras que la lnea de abajo se atribuye al jugador. Los otros agujeros sirven \
para almacenar la semillas comidas durante la partida.

Cada agujero contiene cuatro semillas al principio de la partida.

Los jugadores juegan cada uno su turno. No se puede jugar dos veces seguidas. No se puede \
saltar su turno.

El jugador que juega coge todas las semillas de uno de sus agujeros y las distribuye una a \
una en cada uno de los agujeros siguientes en el sentido contrario a un reloj. No se ponen \
semillas en el agujero inicial (ese caso se encuentra cuando el jugador distribuye ms de \
doce semillas).

Se comen las semillas del ltimo agujero al que se llega cuando este est situado en el \
campo adverso y contiene dos o tres semillas contando la ltima semilla puesta. Se comen \
tambin los agujeros consecutivos precedentes que responden a esta condicin. No se pueden \
comer ms de cuatro agujeros consecutivos. Solo se comen los cuatro ltimos agujeros cuando \
cinco agujeros o ms se pueden comer.

El jugador tiene entonces que dar semillas al adversario cuando no le quedan ms a este. \
Si no puede dar ms semillas, la partida se para.

El jugador que ha comido ms semillas ha ganado.
}
}

proc rule_fr {} {
.rule.txt delete 0.0 end
.rule.txt insert 0.0 \
{Rgles de l'awal.

Le jeu d'awal se dcompose en deux lignes de six trous. La ligne du haut est affecte \
l'ordinateur tandis que la ligne du bas est affecte au joueur. Les autres trous servent  stocker \
les graines "manges" au cours de la partie.

Chaque trou contient quatre graines en dbut de partie.

Les joueurs jouent chacun leur tour. On ne peut pas jouer deux fois de suite. On ne peut pas sauter son tour.

Le joueur qui joue prend toutes les graines de l'un de ses trous et les distribue une  une \
dans les trous suivants en tournant dans le sens anti-horaire. On ne pose pas de graine \
dans le trou de dpart (ce cas de figure se prsente lorsque le joueur distribue plus de douze \
graines).

On "mange" les graines du dernier trou atteint lorsque celui se situe chez l'adversaire et contient deux ou trois graines \
en comptant la dernire graine pose. On "mange" aussi les trous conscutifs prcdents qui respectent \
cette condition. On ne peut pas "manger" plus de quatre trous conscutifs. Seuls les quatre derniers trous sont \
"mangs" lorsque cinq trous ou plus sont "mangeables".

Le joueur est tenu de fournir des graines  l'adversaire lorsque celui-ci n'en possde plus. \
S'il ne peut pas fournir de graines, la partie s'arrte.

Le joueur qui a "mang" le plus de graines a gagn.
}
}

proc rule_uk {} {
.rule.txt delete 0.0 end
.rule.txt insert 0.0 \
{Rules of awale.

Awale game contains two lines of six holes. Each player plays a single line, the \
upper line for the computer and the lower line for the player. Other pair of holes \
are used for eaten seeds.

Every holes contain four seeds at the beginning of the game.

One plays alternately. One never play two turns, one cannot pass his turn.

When playing, take all the seeds of a hole in your line and distribute it \
in successive holes turning counterclock wise, one seed per hole. Do not \
put a seed in the starting hole (this case arrives when the starting hole \
contains more than twelve seeds.)

The seeds of the arrival hole are eaten when the arrival hole lies in the \
opponent line and contains two or three seeds (after all seeds are distributed). \
All contiguous previous holes which meet this condition are also \
eaten. It is possible to eat a maximum of four holes, when five holes are \
eatable, only the last four ones are eaten.

Players have to play such that the opponent always has at least one seed. \
In case it is impossible, the game stops.

The winner is the player who has eaten the most seeds.
}
}

#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                         Change of language
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

proc changeLang {} {
global PLAY NEW OPEN SAVE UNDO QUIT PARA LEVE TWOP OPPO STAR BOTT TOP CONF LING UK FR SP HELP RULE ABOU LANG
global label

.menu entryconfigure  0 -label $PLAY($LANG)
.menu.play entryconfigure  0 -label $NEW($LANG)
.menu.play entryconfigure  1 -label $OPEN($LANG)
.menu.play entryconfigure  2 -label $SAVE($LANG)
.menu.play entryconfigure  3 -label $UNDO($LANG)
.menu.play entryconfigure  4 -label $QUIT($LANG)
.menu entryconfigure  1 -label $PARA($LANG)
.menu.para entryconfigure  0 -label $LEVE($LANG)
.menu.para.level entryconfigure  0 -label $TWOP($LANG)
.menu.para.level entryconfigure  1 -label "$OPPO($LANG) 0"
.menu.para.level entryconfigure  2 -label "$OPPO($LANG) 1"
.menu.para.level entryconfigure  3 -label "$OPPO($LANG) 2"
.menu.para.level entryconfigure  4 -label "$OPPO($LANG) 3"
.menu.para entryconfigure  1 -label $STAR($LANG)
.menu.para.start entryconfigure  0 -label $BOTT($LANG)
.menu.para.start entryconfigure  1 -label $TOP($LANG)
.menu.para entryconfigure  3 -label $CONF($LANG)
.menu.para entryconfigure  2 -label $LING($LANG)
.menu.para.lang entryconfigure 0 -label $UK($LANG)
.menu.para.lang entryconfigure 1 -label $FR($LANG)
.menu.para.lang entryconfigure 2 -label $SP($LANG)
.menu entryconfigure  2 -label $HELP($LANG)
.menu.help entryconfigure  0 -label $RULE($LANG)
.menu.help entryconfigure  1 -label $ABOU($LANG)

if {$label=="BEG"|$label=="RUN"} {affichage NULL}
}


#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
#                           Begin of main
#ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

switch $tcl_platform(platform) {
"unix"      {
    set JOUER awale
            }
"macintosh" {
    set JOUER awale
            }
"windows"   {
    set JOUER awale.exe
            }
}

if {$argc==1&([lindex $argv 0]=="uk"|[lindex $argv 0]=="sp"|[lindex $argv 0]=="fr")} {set LANG [lindex $argv 0]} else {set LANG "uk"}

set BIN [file dirname [info script]]
set HOME $env(HOME)
set PATH $HOME
set level 0
array set depth0 [list 2players 0 0 1 1 7 2 9 3 10]
set start PLAYER
set nbeat 4
set noeat ""
set noall ""
set noatk ""
set label END
for {set i 0} {$i<12} {incr i} {set idtrou($i) 0}
set iturn 0
set indication 0
array set Tmin [list 0 0   1 1 2 3  3 15]
array set Tmax [list 0 999 1 2 2 20 3 100]

array set PLAY [list uk "Play"           fr "Jeu"                sp "Jugar"]
array set NEW  [list uk "New game"       fr "Nouvelle partie"    sp "Nueva partida"]
array set OPEN [list uk "Open"           fr "Ouvrir"             sp "Abrir"]
array set SAVE [list uk "Save"           fr "Sauver"             sp "Guardar"]
array set UNDO [list uk "Undo"           fr "Annuler"            sp "Anular"]
array set QUIT [list uk "Quit"           fr "Quitter"            sp "Salir"]
array set PARA [list uk "Parameters"     fr "Paramtres"         sp "Parmetros"]
array set LEVE [list uk "Level"          fr "Niveau"             sp "Nivel"]
array set TWOP [list uk "Two players"    fr "Deux joueurs"       sp "Dos jugadores"]
array set OPPO [list uk "Computer level" fr "Ordinateur niveau"  sp "Ordenador nivel"]
array set STAR [list uk "First turn"     fr "Premier coup"       sp "Primer turno"]
array set LING [list uk "Language"       fr "Language"           sp "Lengua"]
array set BOTT [list uk "Bottom"         fr "Bas"                sp "Abajo"]
array set TOP  [list uk "Top"            fr "Haut"               sp "Arriba"]
array set CONF [list uk "Configure rule" fr "Configurer la rgle" sp "Configurar las reglas"]
array set DETA [list uk "Detailed rule"  fr "Rgle dtaille"    sp "Reglas detalladas"]
array set HELP [list uk "Help"           fr "Aide"               sp "Ayuda"]
array set RULE [list uk "Rules"          fr "Rgles"             sp "Reglas"]
array set ABOU [list uk "About"          fr "A propos"           sp "Sobre"]
array set UK   [list uk "English"        fr "English"            sp "English"]
array set FR   [list uk "Franais"       fr "Franais"           sp "Franais"]
array set SP   [list uk "Castellano"     fr "Castellano"         sp "Castellano"]
array set WIN  [list uk "You lose"       fr "Je t'ai bien gagn" sp "He ganado"]
array set LOSE [list uk "You win"        fr "Tu m'as bien gagn" sp "Me has ganado"]
array set DRAW [list uk "It's a draw"    fr "C'est mme score"   sp "Igualdad"]
array set CSCO [list uk "Computer score" fr "Score ordinateur"   sp "Score del ordenador"]
array set PSCO [list uk "Player score"   fr "Score joueur"       sp "Score del jugador"]
array set P1CO [list uk "North score"    fr "Score nord"         sp "Score del norte"]
array set P2CO [list uk "South score"    fr "Score sud"          sp "Score del sur"]
array set DEPT [list uk "Depth"          fr "Profondeur"         sp "Profundidad"]
array set TURN [list uk "Turn"           fr "Tour"               sp "Turno"]
array set YES  [list uk "Yes"            fr "Oui"                sp "Si"]
array set NO   [list uk "No"             fr "Non"                sp "No"]
array set OK   [list uk "OK"             fr "OK"                 sp "VALE"]
array set DEFA [list uk "DEFAULT" fr "DEFAUT" sp "DEFECTO"]
array set MAXI [list uk "Maximum number of holes that can be eaten"\
                     fr "Nombre maximum de trous  manger"\
                     sp "Cantidad mxima de agujeros que comer"]
array set EATL [list uk "Eat the last holes when trying to eat more than the maximum"\
                     fr "Mange les derniers trous lorsqu'on dpasse le maximum"\
                     sp "Come los ltimos agujeros cuando se pasa del mximo"]
array set EATN [list uk "Eat nothing when trying to eat more than the maximum"\
                     fr "Ne mange rien lorsqu'on dpasse le maximum"\
                     sp "No come nada cuando se pasa del mximo"]
array set EATA [list uk "Possible to eat all opponent seeds"\
                     fr "Possibilit de manger toutes les graines adverses"\
                     sp "Se puede comer todos los agujeros del adversario"]
array set NOAL [list uk "Eat nothing when trying to eat all opponent seeds"\
                     fr "Ne mange rien lorsqu'on attaque toutes les graines adverses"\
                     sp "No come nada cuando se intenta comer todas las semillas adversas"]
array set ATKA [list uk "Allow to play a move which attacks all opponent seeds"\
                     fr "Possibilit d'attaquer toutes les graines adverses"\
                     sp "Se puede atacar todos los agujeros del adversario"]
array set NOAK [list uk "Forbidden to play a move which attacks all opponent seeds"\
                     fr "Interdiction d'attaquer toutes les graines adverses"\
                     sp "No se puede atacar todas las semillas adversas"]
array set IFIL [list uk "Select file to import" \
                     fr "Choisir le fichier  importer" \
                     sp "Elegir el fichero para importar"]
array set SFIL [list uk "Select file to save" \
                     fr "Choisir le fichier  importer" \
                     sp "Qu fichero quieres ?"]
array set EFIL [list uk "ERROR when opening file" \
                     fr "ERREUR lors de l'ouverture du fichier" \
                     sp "ERROR cuando se abre el fichero"]

openConf

wm title . "Awale"

# creation du menu

menu .menu -tearoff 0

set m .menu.play
menu $m -tearoff 0
.menu add cascade -label $PLAY($LANG) -menu $m -underline 0
$m add command -label $NEW($LANG)  -accelerator Crtl+N -command {initGame}
$m add command -label $OPEN($LANG) -accelerator Crtl+O -command {importGame}
$m add command -label $SAVE($LANG) -accelerator Crtl+S -command {saveGame}
$m add command -label $UNDO($LANG) -accelerator Crtl+Z -command {undo}
$m add command -label $QUIT($LANG) -accelerator Crtl+Q -command {saveConf; destroy .}
bind . <Control-n> {initGame}
bind . <Control-o> {importGame}
bind . <Control-s> {saveGame}
bind . <Control-z> {undo}
bind . <Control-q> {destroy .}


set m .menu.para
menu $m -tearoff 0
.menu add cascade -label $PARA($LANG) -menu $m -underline 0
$m add cascade -label $LEVE($LANG) -menu $m.level
menu $m.level -tearoff 0
$m.level add radio -label "$TWOP($LANG)"   -variable level -value "2players"
$m.level add radio -label "$OPPO($LANG) 0" -variable level -value 0 \
                                           -command "set depth $depth0(0)"
$m.level add radio -label "$OPPO($LANG) 1" -variable level -value 1
$m.level add radio -label "$OPPO($LANG) 2" -variable level -value 2
$m.level add radio -label "$OPPO($LANG) 3" -variable level -value 3
$m add cascade -label $STAR($LANG) -menu $m.start
menu $m.start -tearoff 0
$m.start add radio -label $BOTT($LANG) -variable start -value "PLAYER"
$m.start add radio -label $TOP($LANG)  -variable start -value "COMPUTER"
$m add cascade -label $LING($LANG) -menu $m.lang
menu $m.lang -tearoff 0
$m.lang add radio -label $UK($LANG) -variable LANG -value "uk" -command {changeLang}
$m.lang add radio -label $FR($LANG) -variable LANG -value "fr" -command {changeLang}
$m.lang add radio -label $SP($LANG) -variable LANG -value "sp" -command {changeLang}
$m add command -label $CONF($LANG) -command {configureRules}

set m .menu.help
menu $m -tearoff 0
.menu add cascade -label $HELP($LANG) -menu $m -underline 0
$m add command -label $RULE($LANG) -command {helpDialog}
$m add command -label $ABOU($LANG) -command {copyrightDialog FALSE}

. configure -menu .menu


# creation of the main image

set fond [image create photo -file [file join $BIN Awale.gif]]
set largeur [image width $fond]
set hauteur [image height $fond]
for {set i  0} {$i<10} {incr i} {set img($i) [image create photo -file [file join $BIN Trou0$i.gif]]}
for {set i 10} {$i<49} {incr i} {set img($i) [image create photo -file [file join $BIN Trou09.gif]]}

canvas .cnv -width $largeur -height $hauteur -cursor top_left_arrow
bind .cnv <ButtonPress-1> "jouer %x %y $largeur $hauteur"
bind .cnv <ButtonPress-3> "contenu %x %y $largeur $hauteur"
pack .cnv -side top -anchor nw

.cnv create image [expr $largeur/2] [expr $hauteur/2] -image $fond

# ecran d'acceuil

copyrightDialog TRUE
after 2000 {destroy .copyright}
