/* 
*  This file is part of BCC.
*
*  BCCsuite is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCCsuite is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#include "IO.h"

void IO_open_ascii(bcc_status* status, FILE **f, const char* name)
{
  char infostr[BCCStringLength];
  
  CHECKSTATUSPTR(status);

  ASSERT(f,status,IO_ENULL,IO_MSGENULL);
  ASSERT(*f==NULL,status,IO_ENNULL,IO_MSGENNULL);
  ASSERT(name,status,IO_ENULL,IO_MSGENULL);

  *f=fopen(name,"r");
  if (*f==NULL)
    {ABORT(status,IO_EOPENF,IO_MSGEOPENF);}

  sprintf(infostr,"Open ASCII file %s\n",name);
  bcc_log(status,infostr);

  RETURN(status);

}

void IO_close_ascii(bcc_status* status, FILE **f)
{
  int stat;
  char infostr[BCCStringLength];

  CHECKSTATUSPTR(status);

  ASSERT(f,status,IO_ENULL,IO_MSGENULL);
  ASSERT(*f,status,IO_ENULL,IO_MSGENULL);

  sprintf(infostr,"Close ASCII file\n");
  bcc_log(status,infostr);

  stat=fclose(*f);
  if (stat == EOF)
    {ABORT(status, IO_ECLOSE, IO_MSGECLOSE);}
  *f=NULL;

  RETURN(status);
}

void IO_read_ascii(bcc_status* status, int *stat, time_series *out, const FILE *f, const char* channel,  const double epoch, const int N)
{
  CHECKSTATUSPTR(status);

  RETURN(status);
}

void IO_info_ascii(bcc_status *status, double *fs, const FILE *f, const char* channel, const double time)
{
  CHECKSTATUSPTR(status);

  RETURN(status);
}
