/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _DWV_H
#define _DWV_H

#include "factories.h"
#include "error.h"

#include <fftw3.h>

#ifdef  __cplusplus
extern "C" {
#endif
  
  /* data structures */

  /* prototypes */

  void create_FFTW_plan(bcc_status*, fftw_plan** , const matrix *, const unsigned);
  void destroy_FFTW_plan(bcc_status*, fftw_plan**);
  void dwv(bcc_status*, matrix *, const  vector *, const int, const fftw_plan *);

  /* error management */

#define DWV_EVPTR 1
#define DWV_EUPTR 2
#define DWV_EDPTR 3
#define DWV_ENULL 4
#define DWV_EFRQZ 5
#define DWV_EMALLOC 6
#define DWV_ETIDX 2

#define DWV_MSGEVPTR "Null chirplet chain handle"
#define DWV_MSGEUPTR "Non-null chirplet chain pointer"
#define DWV_MSGEDPTR "Null chirplet chain data"
#define DWV_MSGENULL "Null pointer"
#define DWV_MSGEFRQZ "Invalid number of frequency bins"
#define DWV_MSGEMALLOC  "Malloc failure"
#define DWV_MSGETIDX "Invalid time index"

#ifdef  __cplusplus
}
#endif

#endif /* _DWV_H */
