/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#ifndef _BCC_FACTORIES_H
#define _BCC_FACTORIES_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include "error.h"

#ifdef  __cplusplus
extern "C" {
#endif

  enum { BCCStringLength = 64, BCCMaxDetectorNumber=4};


  typedef enum tagbcc_boolean 
    {BCC_FALSE=0,BCC_TRUE=1} bcc_boolean;
  
  typedef struct tagvector{
    int length;
    double *data;
  } vector;

  typedef struct tagmatrix{
    int rows;
    int columns;
    double *data1;
    double **data2;
  } matrix;
  
  typedef struct tagint_array {
    int rows;
    int columns;
    int * data1;    /* used if rows or columns =1 */
    int **data2;    /* used otherwise */
  } int_array;
  
/* typedef struct tagbool_array{ */
/*     int length; */
/*     BCC_BOOLEAN *data; */
/*   } bool_array; */

  typedef struct tagtime_series{
    double epoch;  /* epoch of the stream [ seconds ]*/
    double deltaT; /* sampling period [ seconds ] */
    vector *vec;
  } time_series;


  typedef struct tagbuffer{
    double epoch;  /* epoch of the stream [ seconds ]*/
    double deltaT; /* sampling period [ seconds ] */
    int allocated; /* buffer size */
    int used;      /* number of samples in the buffer */
    vector *vec;
    // int n_segments;
  } buffer;

  /* prototypes */

  void create_vector(bcc_status*, vector **, const int);
  void destroy_vector(bcc_status *, vector **);
  void create_matrix(bcc_status *, matrix ** ,const int ,const int);
  void destroy_matrix(bcc_status *, matrix **);
  void create_array(bcc_status *, int_array ** ,const int ,const int);
  void destroy_array(bcc_status *, int_array **);
  void create_string(bcc_status*, char ** , const int );
  void destroy_string(bcc_status *, char ** );
  void create_time_series(bcc_status*, time_series **, const int, const double, const double);
  void destroy_time_series(bcc_status*, time_series **);
  void create_buffer(bcc_status*, buffer **, const int, const double, const double);
  void destroy_buffer(bcc_status*, buffer **);

  /* error management */

#define BCC_FLOAT_EPS 1.19209290e-07 /* 0.5^(MANTISSA-1) */
/* I.e. the difference between 1 and the next resolveable float */
#define BCC_DOUBLE_EPS 2.2204460492503131e-16  /* 0.5^(MANTISSA-1) */
/* I.e. the difference between 1 and the next resolveable double */

#define BCC_FACTORIES_EHPTR   1
#define BCC_FACTORIES_ENNPTR  2
#define BCC_FACTORIES_ENPTR   4
#define BCC_FACTORIES_EDPTR   8
#define BCC_FACTORIES_EMALLOC 16
#define BCC_FACTORIES_EOZ     32
#define BCC_FACTORIES_EDELTAT 64

#define BCC_FACTORIES_MSGEHPTR    "Null object handle."
#define BCC_FACTORIES_MSGENNPTR   "Non-null object pointer."
#define BCC_FACTORIES_MSGENPTR    "Null object pointer."
#define BCC_FACTORIES_MSGEDPTR    "Null object data."
#define BCC_FACTORIES_MSGEMALLOC  "Malloc failure."
#define BCC_FACTORIES_MSGEOZ      "Invalid object size."
#define BCC_FACTORIES_MSGEDELTAT  "Invalid sampling interval."

#ifdef  __cplusplus
}
#endif

#endif /* _BCC_FACTORIES_H */
