/* 
*  This file is part of BCC.
*
*  BCC is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  BCC is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with BCC; if not, write to the Free Software
*  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*
*  Copyright (C) 2006 Eric Chassande-Mottin, CNRS
*
*/
 
#include "parse.h"

int bccDebugLevel = BCCINFO;

const int StringLength=64;
static char* input;

const char* DEFAULT="parse_test.cfg";

static void
Usage (
    const char *program,
    int         exitcode
      )
{
  fprintf (stderr, "Usage: %s [options]\n", program);
  fprintf (stderr, "Options (defaults shown in square brackets):\n");
  fprintf (stderr, "    -i  config file  [parse_test.cfg]\n");
  exit (exitcode);
}

static void
ParseOptions (int argc, char *argv[])
{
  int i;
  
  for (i = 1; i < argc; i++)
    if (strcmp(argv[i],"-i")==0)
      input=argv[++i];
    else if (strcmp(argv[i],"-h")==0)
      Usage (argv[0], 1);
}

int
main (int argc, char *argv[])
{
  char *buffer=NULL;

  char string[StringLength];
  double real;
  int integer;
  bcc_boolean bool;

  bcc_boolean result;
  static bcc_status status;

  ParseOptions (argc,argv);

  if (input==NULL)
    input=DEFAULT;

  INITSTATUSPTR(&status);

  SUB(copy_file_to_buf(&status,&buffer,input),&status);

  fprintf(stdout,"BCC: parse, read and parse following file\n");
  fprintf(stdout,"\n----- file starts here ------\n");
  fprintf(stdout,"%s",buffer);
  fprintf(stdout,"\n----- file ends here ------\n");

  fprintf(stdout,"BCC: results are:\n\n");
  SUB(parse(&status,&result,&string,buffer,"READ_STRING",BCCString),&status);
  if (result==BCC_TRUE)
    fprintf( stdout, "BCC: READ_STRING = %s\n\n",string);  
  else
    fprintf( stdout, "BCC: no input found for READ_STRING\n\n");  
  SUB(parse(&status,&result,&real,buffer,"READ_REAL",BCCReal),&status);
  if (result==BCC_TRUE)
    fprintf( stdout, "BCC: READ_REAL = %f\n\n",real);
  else
    fprintf( stdout, "BCC: no input found for READ_REAL\n\n");  
  SUB(parse(&status,&result,&integer,buffer,"READ_INTEGER", BCCInteger),&status);
  if (result==BCC_TRUE)
    fprintf( stdout, "BCC: READ_INTEGER = %d\n\n",integer);
  else
    fprintf( stdout, "BCC: no input found for READ_INTEGER\n\n");  
  SUB(parse(&status,&result,&bool,buffer,"READ_BOOLEAN",BCCBoolean),&status);
  if (result==BCC_TRUE)
    fprintf( stdout, "BCC: READ_BOOLEAN = %d\n\n",bool);
  else
    fprintf( stdout, "BCC: no input found for READ_BOOLEAN\n\n");  

  SUB(destroy_string(&status,&buffer),&status);

  return (EXIT_SUCCESS);
}
