##ANTENNA   Antenna pattern
##          P=ANTENNA(DETECTOR,PHI,THETA) computes the antenna
##          pattern of a detector in given sky directions
##
##          DETECTOR        :  detector structure
##          PHI             :  source direction grid, azimuth angle from x-axis
##          THETA           :  source direction grid, polar angle from zenith
##          P               :  complex antenna pattern function
##

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France) and Archana Pai, AEI (Germany)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: antenna.m,v 1.3 2008/09/03 14:00:51 ecm Exp $

function plus = antenna(detector,phi,theta)

  if (nargin<3)
    error("Usage: delta=antenna(detector,phi,theta)");
  end;
  
  if (size(phi)~=size(theta)),
    error("phi and theta must have same size");
  end;
  
  d=length(detector);
  
  if d>1
    plus=zeros([size(theta) d]);
    ## minus=zeros([size(theta) d]);
  else
    plus=zeros(size(theta));
    ## minus=zeros(size(theta));
  end;

  theta=pi-theta; ## convert from polar angle to Euler angles
  phi-=pi/2;      ## convert from polar angle to Euler angles

  for n=1:d,

    alpha=detector(n).alpha;
    beta=detector(n).beta;
    gamma=detector(n).gamma;

    for s=-2:+2,
      tmp=gelfand(+2,s,alpha,beta,gamma)-gelfand(-2,s,alpha,beta,gamma);
      term=-i*gelfand(+2,s,phi,theta,zeros(size(phi)))*conj(tmp);
      if d>1
	plus(:,:,n)+=reshape(term,[size(phi) 1]); 
      else
	plus+=term;
      end;
      ## minus+=-i*gelfand(-2,s,phi,theta,zeros(size(phi)))*conj(tmp);
    end;
  end;
  
  return;
