function [window olaStride]= bccwindow(windowLength,windowType)

% verify correct number of input arguments
error(nargchk(1, 2, nargin));

% apply default arguments
if (nargin < 2) || isempty(windowType),
  windowType = "hanning";
end

% generate window
switch windowType
  case "hamming"
    m = (0:windowLength-1)'/(windowLength-1);
    window = .54 - .46*cos(2*pi*m);
    window(1) /= 2.0;
    window(windowLength) /= 2.0;
    olaStride = (windowLength-1)/2.0;
  case "hanning"
    m = (1:windowLength)'/(windowLength+1);
    window = .5 * (1 - cos(2*pi*m));
    olaStride = (windowLength+1)/2.0;
  case "kaiser"
    beta = 15.0;
    window = kaiser(windowLength,beta);
    olaStride = floor(windowLength/5.5); % ROUGH estimate!
  otherwise
    error("bccwindow: unknown window type");
endswitch
