##CREATE_DETECTOR  Create detector structure 
##          DET=CREATE_DETECTOR(PREFIX,TYPE,NAME,LONG,LAT,ORIENT,EL) 
## creates and fills a detector structure
##
##
##          PREFIX          :  detector prefix
##          TYPE            :  detector type
##          NAME            :  detector name
##          LONG            :  longitude, azimut angle from the prime meridian anticlockwise (radian)
##          LAT             :  latitude, polar angle from equator anticlockwise (radian)
##          ORIENT=[AZIMUT_X, AZIMUT_Y] :  detector orientation as given by arm azimuth anticlockwise from N (radian) 
##          EL              : elevation wrt to WSG-84 earth model ellipsoid

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France) and Archana Pai, AEI (Germany)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: create_detector.m,v 1.3 2008/09/03 14:00:51 ecm Exp $

function d=create_detector(prefix,type,name,long,lat,orient,el)

if (nargin<7)
  error("Usage: d=create_detector(prefix,type,name,lat,long,orient,el)");
end;

[alpha beta gamma]=euler_angles(long,lat,orient(1),orient(2));

r=wgs84(long,lat)+el;

d=struct("prefix",prefix,"type",type,"name",name,"latitude",lat,"longitude",long,"arm_azimut_CCW_N",orient,"elevation",el,"radius",r,"alpha",alpha,"beta",beta,"gamma",gamma);

return;
