##DEGENERACY   Network conditioning number
##             D=DEGENERACY(DETECTOR,PHI,THETA) computes the conditioning
##             number of the antenna pattern function of a given network
##
##             DETECTOR        :  detector structure
##             PHI             :  source direction grid, azimuth angle from x-axis
##             THETA           :  source direction grid, polar angle from zenith
##             
##

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: degeneracy.m,v 1.2 2008/09/03 14:00:51 ecm Exp $

function degen = degeneracy(det,phi,theta)

  if (nargin<3)
    error("Usage: d=degeneracy(detector,phi,theta)");
  end;

  if any(size(phi)~=size(theta)),
    error("phi and theta must have same size");
  end;
  
  d=length(det);
  
  p=antenna(det,phi,theta);
  
  calD=squeeze(sum(abs(p).^2,3));
  Delta=squeeze(sum(p.^2,3));

  eigv_plus=sqrt(calD+abs(Delta));
  eigv_minus=sqrt(calD-abs(Delta));
  degen=eigv_plus./eigv_minus;

return