##EULER_ANGLES  Detector Euler angles
##          [ALPHA BETA GAMMA]=EULER_ANGLE(LONG,LAT,AZIMUT_X,AZIMUT_Y) 
##          computes the three Euler angles of the rotation which
##          transforms the detector frame (defined as follows: The
##          x-axis bisects the angle between the detector arms. The
##          direction of the y-axis is chosen in such a way that the
##          detector frame forms a right-handed coordinate system with
##          the z-axis pointing radially out of Earth's surface.) into
##          the fide (defined as follows: The x-axis lies along the line
##          joining Earth's center and the equatorial point that lies on
##          the meridian passing through Greenwich, England. It points
##          radially outwards. The z-axis is taken to lie in the
##          direction of the line passing through the center of Earth
##          and the north pole. The y-axis is chosen to form a
##          right-handed coordinate system with the x- and z-axes.) 
##          Ref: Pai et al., Phys. Rev. D64 (2001) 042004
##
##          LONG               :  longitude (radian) 
##          LAT                :  latitude (radian) 
##          AZIMUT_X           :  x arm azimuth anticlockwise from N (radian) 
##          AZIMUT_Y           :  y arm azimuth anticlockwise from N (radian) 
##          ALPHA, BETA, GAMMA : the three Euler angles
##

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France) and Archana Pai, AEI (Germany)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: euler_angles.m,v 1.2 2008/09/03 14:00:51 ecm Exp $

function [alpha beta gamma]=euler_angles(long,lat,azimut_x,azimut_y)

if (nargin<4)
  error("Usage: euler_angles(long,lat,azimut_x,azimut_y)");
end;

alpha=long+pi/2;
beta=pi/2-lat;

if (abs(azimut_x-azimut_y)>pi)
  gamma=(azimut_x+azimut_y)/2.0+3*pi/2;
else
  gamma=(azimut_x+azimut_y)/2.0+pi/2;
end

gamma=mod(gamma,2*pi);

return;
