##GELFAND   Rank-2 Gel'fand functions
##          F=GELFAND(M,N,PHI,THETA,PSI) computes the rank-2 Gel'fand
##          function.
##
##          M,N             :  indices (between -2 and +2)
##          PHI, THETA, PSI :  input angles
##          F               :  Gel'fand function

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: gelfand.m,v 1.2 2008/09/03 14:00:51 ecm Exp $

function f=gelfand(m,n,phi,theta,psi)

if (nargin<5)
  error("Usage: f=gelfand(m,n,phi,theta,psi)");
end;

if ((m-fix(m)>0)|(m<-2)|(m>2))
  error("m should be and integer between -2 and 2");
end;

if ((n-fix(n)>0)|(n<-2)|(n>2))
  error("m should be and integer between -2 and 2");
end;

##printf("m=%d n=%d\n",m,n);

mm=m;
nn=n;

if (m<-n)
  tmp=m;
  m=-n;
  n=-tmp;
  ## printf("a m=%d n=%d\n",m,n);
end

if (m<=n)
  tmp=m;
  m=n;
  n=tmp;
  ## printf("b m=%d n=%d\n",m,n);
end;
  
if ((size(phi)~=size(theta))|(size(phi)~=size(psi)))
  error("phi, theta and phi must have same size");
end;

## printf("m=%d n=%d\n",m,n);

switch m
  case 0
    switch n
      case 0
	f=.5*(3*(cos(theta)).^2-1);
      otherwise
	error("unknown Gelfand order");
    end
    
  case +1
    switch n
      case -1
	f=.5*(2*(cos(theta)).^2-cos(theta)-1);
      case 0
	f=-sqrt(3/2)*i*sin(theta).*cos(theta);
      case +1
	f=.5*(2*(cos(theta)).^2+cos(theta)-1);
      otherwise
	error("unknown Gelfand order");
    end
    
  case +2
    switch n
      case -2
	f=.25*(cos(theta)-1).^2;
      case -1
	f=-.5*i*sin(theta).*(cos(theta)-1);
      case 0
	f=-.5*sqrt(3/2)*(sin(theta)).^2;
      case +1
	f=-.5*i*sin(theta).*(cos(theta)+1);
      case +2
	f=.25*(cos(theta)+1).^2;
      otherwise
	error("unknown Gelfand order");
    end
    
  otherwise
    error("unknown Gelfand order");
    
end

f=f.*exp(-i*(nn*phi+mm*psi));

return;