## Geographical to cartesian coordinates
##          VECT=GEO_TO_CART(RADIUS,LONG,LAT) converts
## the geographical to cartesian coordinates.
##
##          RADIUS          :  distance from the origin
##          LONG            :  longitude (radian)
##          LAT             :  latitude (radian)
##          VECT            :  3D vector containing the cartesian coordinates

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: geo_to_cart.m,v 1.2 2008/09/03 14:00:51 ecm Exp $

function vect=geo_to_cart(radius,long,lat)

if (nargin<3)
  error("Usage: vect=geo_to_cart(radius,lat,long)");
end;

lat=vec(lat)';
long=vec(long)';

vect=radius.*[cos(lat).*cos(long);cos(lat).*sin(long);sin(lat)];

return;
