##NETWORK_STR   Concatenate the names of the detectors in a string

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: network_str.m,v 1.3 2008/09/03 14:00:52 ecm Exp $

function str=network_str(det,opt)

if isempty(opt)
  opt="name";
endif;

d=length(det);

if strcmp(opt,"name")
  str=sprintf("%s",det(1).name);
elseif strcmp(opt,"prefix")
  str=sprintf("%s",det(1).prefix);
else
  error("network_str: unknown optional argument %s",opt);
end;
  
if (d>1)
  for n=2:d,
    if strcmp(opt,"name")
      str=sprintf("%s+%s",str,det(n).name);
    elseif strcmp(opt,"prefix")
      str=sprintf("%s+%s",str,det(n).prefix);
    endif;
  end;
end;
