## Spherical to cartesian coordinates
##          VECT=SPH_TO_CART(RADIUS,PHI,THETA) converts
## the spherical to cartesian coordinates.
##
##          RADIUS          :  distance from the origin
##          PHI             :  source direction grid, azimut angle from x-axis
##          THETA           :  source direction grid, polar angle from zenith
##          VECT            :  3D vector containing the cartesian coordinates
##

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##
## $Id: sph_to_cart.m,v 1.2 2008/09/03 14:00:52 ecm Exp $

function vect=sph_to_cart(radius,phi,theta)

if (nargin<3)
  error("Usage: vect=sph_to_cart(radius,phi,theta)");
end;

if (size(radius)~=size(phi))|(size(radius)~=size(theta))
  error("radius, phi and theta should have same size");
end;

radius=vec(radius)';
phi=vec(phi)';
theta=vec(theta)';

vect=repmat(radius,[3 1]).*[sin(theta).*cos(phi);sin(theta).*sin(phi);cos(theta)];

return;
