## evaluate the degeneracy of a given network

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: degeneracyt.m,v 1.1 2008/09/05 14:55:39 ecm Exp $

clear;

worst_case_plot=0;

usual_detectors;

det=[LH LL V]; # select your detector(s) here
##det=[V LH];
##det=[D1 D3];

N=128;

theta_v=linspace(pi,0,N);
phi_v=linspace(-pi,pi,N);
[phi,theta]=meshgrid(phi_v,theta_v);

degen=degeneracy(det,phi,theta);

latitude=pi/2-theta_v;
longitude=phi_v;

levels=[1.1 1.5 2 10];

d=length(det);

__gnuplot_set__ key

xlabel("longitude (radian)");
ylabel("latitude (radian)");
eval(sprintf("title('degeneracy of { %s }');",network_str(det)));
axis([longitude(1) longitude(end) latitude(1) latitude(end)]);

if (d>1)
  contour(longitude,latitude,degen,levels);
end;

%%colormap(jet);
%%imagesc(flipud(log10(degen)));

if (worst_case_plot==1)
  figure(2);
  worst_deg=max(max(degen))
  
  [m,n]=find(degen==worst_deg);
  pp=squeeze(p(m,n,:));
  
  xlabel("real");
  ylabel("imag");
  title("complex antenna pattern in the worst case");
  axis("square");
  plot([zeros(d,1) pp].')
end;