## Test of dwv.m

## Copyright (C) 2004 Eric Chassande-Mottin
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## $Id: dwvt.m,v 1.1 2008/09/05 14:55:41 ecm Exp $

## -- check various properties of the proposed WV

clear

N=16;
x=randn(N,1);
idx=1:N;
fs=3;
ts=1/fs;
t=ts*idx;
f=fs*(0:N/2)/N;

## -- compute Wigner-Ville
wx=dwv(x,idx,fs);
df=fs/(2*N);
f_w=fs*(0:N)/(2*N);

## -- check energy
e=ts*sum(x.^2);
e_w=ts*df*sum(sum(wx));
d=(e-e_w)/e;

printf('dwvt, test1: energy distribution\n');
printf('signal energy = %2.1f\n',e);
printf('computed wv   = %2.1f [%d%%]\n',e_w,round(100*d));

if (abs(d)>eps),
  error('dwvt: test1 failed');
else
  printf('dwvt: test1 OK\n\n');
end;

## -- check time and frequency marginals
xt=x.^2;
wt=df*sum(wx);
xf=abs(ts*fft(x)).^2;
wf=ts*sum(wx');

printf('dwvt, test2: time marginal\n');
printf('three first samples of x(t)^2   = %2.1f %2.1f %2.1f\n',xt(1),xt(2),xt(3));
printf('three first samp. of time marg. = %2.1f %2.1f %2.1f\n',wt(1),wt(2),wt(3));
d=abs(xt-wt');
md=max(d);
idxm=find(d==md);
wdt=md/xt(idxm(1));
printf('max rel. diff between x(t)^2 and time marg. = %d%%\n',round(100*wdt));

if (abs(wdt)>10*eps),
  error('dwvt: test2 failed');
else
  printf('dwvt: test2 OK\n\n');
end;

printf('dwvt, test3: frequency marginal\n');
printf('three first samples of |X(f)|^2   = %2.1f %2.1f %2.1f\n',xf(1),xf(2),xf(3));
printf('three first samp. of freq. marg.  = %2.1f %2.1f %2.1f\n',wf(1),wf(3),wf(5));
d=abs(xf(1:N/2+1)'-wf(1:2:N+1));
md=max(d);
idxm=find(d==md);
wdf=md/xf(idxm(1));
printf('max rel. diff between |X(f)|^2 and freq. marg. = %d%%\n',round(100*wdf));

if (abs(wdf)>10*eps),
  error('dwvt: test3 failed');
else
  printf('dwvt: test3 OK\n\n');
end;

## -- check Moyal's formula
y=randn(N,1);
wy=dwv(y,idx,fs);

xy=(ts*x'*y)^2;
xy_w=ts*df*sum(sum(wx.*wy));
d=(xy-xy_w)/xy;

printf("dwvt, test4: Moyal's formula\n");
printf('cross product = %2.1f\n',xy);
printf('computed wv   = %2.1f [%d%%]\n',xy_w,round(100*d));

if (abs(d)>10*eps),
  error('dwvt: test4 failed');
else
  printf('dwvt: test4 OK\n\n');
end;

## -- weyl
a=rand(N);
b=weyl(a,fs);
wxy=dxwv([x,y],idx,fs);

z=ts*a*x;
xay=ts*y'*z;
xay_w=ts*df*sum(sum(b.*wxy));
remind=imag(xay_w);
xay_w=real(xay_w);

printf("-- Weyl's correspondence\n");
printf('quadratic form = %2.1f\n',xay);
printf('computed wv    = %2.1f [%d%%]\n',xay_w,round(100*(xay-xay_w)/xay));
printf('check round off error on imag. part = %2.1e\n',remind);

