## tests for inject_gwchirp.m

##
## Copyright (C) 2006 Eric Chassande-Mottin, CNRS (France)
##
## This program may be freely copied under the terms of the 
## GNU General Public License (GPL), version 2, or at your 
## option any later version.
##

## $Id: inject_gwchirpt.m,v 1.1 2008/09/05 14:55:42 ecm Exp $

clear;

precision=1e-7;

usual_detectors;

## work in normalized distance unit

D1.radius=1.0;
D2.radius=1.0;
D3.radius=1.0;

N=128;

## define GW chirp

t=(0:N-1)';
phase=pi/2*t.^2/(N-1);
phase0=rand*2*pi;
s=exp(i*(phase+phase0));
phi=0.0;
theta=pi/2;
epsilon=pi*rand;      # in [0, pi]
psi=pi*rand-pi/2;     # in [-pi/2, pi/2]
snr=5;

pad=16;

printf("test1: 2 parallel detectors\n");

net=[D1 D2];
white=ones([size(phi) length(net)]);
x=inject_gwchirp(net,s,snr,phi,theta,epsilon,psi,white,pad,1.0);

if (any(abs(x(pad+t-1,1)+x(pad+t+1,2))>precision))
  error("test1 failed\n");
else
  printf("test1 passed\n");
end;

printf("test2: check calibration\n");

measured_snr=sqrt(sum(sum(x.^2)));

if (abs(snr-measured_snr)>precision)
  error("test2 failed\n");
else
  printf("test2 passed\n");
end;

printf("test3: 1 blind detector\n");

net=D3;
white=ones([size(phi) length(net)]);
x=inject_gwchirp(net,s,-1.0,phi,theta,epsilon,psi,white,pad,1.0);

if any(abs(x(pad+t,1))>precision)
  error("test3 failed\n");
else
  printf("test3 passed\n");
end;
