%  The units on the power spectra PS are such that, using
%  Parseval's theorem: 
%
%  SUM(PS)/LENGTH(PS) = SUM(X.^2)/LENGTH(X) = COV(X)
%
%  Here are the covariance, RMS, and spectral amplitude values of
%  some common functions:
%
%          Signal   Cov=SUM(PS)/LENGTH(PS)    RMS         PS
%          a*sin(w*t)        a^2/2            a/sqrt(2)   a^2*LENGTH(PS)/2
% Normal:  a*randn(t)        a^2              a           a^2
% Uniform: a*rand(t)         a^2/12           a/sqrt(12)  a^2/12
%   


N=1024; 

%Nh=1023;
%h=hanning(Nh);
h=ones(N-1,1); 

a=1;
sig=a*sin(2*pi*1/4*(0:N-1)); b=a^2*N/4;
#sig=a*randn(N,1); b=a^2;
#sig=a*(rand(N,1)-.5); b=a^2/12;

s1=welch(sig,h,0.5,N);
#s2=abs(fft(sig).^2)/(N-1);

plot(s1,"b");
hold on;
#plot(s2(1:N/2),"r");
plot([1 N],[b b],'r')
hold off;
