#!/bin/sh
#
# retrieve_incomplete_jobs.sh [runNumber]
#
# Retrieve incomplete jobs from logs

# Eric Chassande-Mottin

# $Id: retrieve_incomplete.sh,v 1.2 2008/11/03 16:45:49 ecm Exp $

# parse command line arguments
if [ $# -ge 1 ]; then
  runNumber=`printf "%01d" $1`
fi

# check if run directory exist
if [ ! -d ${runNumber} ]; then
    echo "missing run directory"
    exit 0
fi

# report on the run status
echo "submission tables are"
wc -l analysis*.batch
echo -n "number of stdout logs found is "; ls -1 ${runNumber}/log/stdout/stdout* | wc -l
echo -n "number of stderr logs found is "; ls -1 ${runNumber}/log/stderr/stderr* | wc -l

# report incomplete and failed jobs
incompleteJobs=incomplete_jobs${runNumber}; 
failedJobs=failed_jobs${runNumber};

rm -f ${incompleteJobs} ${failedJobs} executed_jobs

touch ${incompleteJobs} ${failedJobs} executed_jobs
for logFile in `find ${runNumber}/log/stdout/stdout*` ; do 
    lastBlock=`grep analyzing $logFile | tail -1 | awk '{print $3}'`
    blockNumber=`grep analyzing $logFile | tail -1 | awk '{print $5 }'`
    startTime=`echo $logFile | cut -d"_" -f 2`
    stopTime=`echo $logFile | cut -d"_" -f 3 | sed -e 's/.txt//'`
    echo ${startTime} ${stopTime} >> executed_jobs
    if [ -z ${lastBlock} ]; then
	echo ${startTime} ${stopTime} >> ${failedJobs}
    else
	if [ "${lastBlock}" != "${blockNumber}" ]; then
	    echo ${startTime} ${stopTime} >> ${incompleteJobs}
	fi
    fi
done

echo -n "number of failed jobs is "; wc -l ${failedJobs} | cut -d" " -f 1
echo -n "number of incomplete jobs is "; wc -l ${incompleteJobs} | cut -d" " -f 1

# report missing jobs
cat analysis*.batch | awk '{printf $NF "\n"}' | sed -e 's/\.*batch\/*//g' -e 's/-/ /' > submitted_jobs
cat submitted_jobs executed_jobs | sort | uniq -u > missing_jobs
rm -f submitted_jobs executed_jobs

echo -n "number of missing jobs is "; wc -l missing_jobs | cut -d" " -f 1

# generate submission list
rm -f reanalysis.batch
if [ -s "${incompleteJobs}" ]; then
    sed -e 's/ /.*/' ${incompleteJobs} > patterns.tmp
    grep -f patterns.tmp analysis*.batch | cut -d":" -f 2 >> reanalysis.batch
    rm -f patterns.tmp
fi

if [ -s "${failedJobs}" ]; then
    sed -e 's/ /.*/' ${failedJobs} > patterns.tmp
    grep -f patterns.tmp analysis*.batch | cut -d":" -f 2 >> reanalysis.batch
    rm -f patterns.tmp
fi

if [ -s reanalysis.batch ]; then
    echo -n "number of jobs in the resubmission list is "; wc -l reanalysis.batch
    chmod a+x reanalysis.batch
fi

# return exit status
exit $error
