#!/usr/bin/env octave-q

## Copyright (C) 2008 Eric Chassande-Mottin, CNRS (France)

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, see .

if nargchk(2,3,nargin)
    usage("split_segments.sh file.txt max_duration [overlap]");
endif

args=argv();

filename=args{1};
max_duration=str2num(args{2});
if length(args)==2
  overlap=0;
else
  overlap=str2num(args{3});
endif

if ~exist(filename,"file")
  error("file not found");
endif

eval(sprintf("data=load %s;",filename));;

if overlap >= max_duration
  error("overlap should be smaller than segment duration");
endif

alphabet="abcdefghijklmnopqrstuvwxyz";
nalphabet=length(alphabet);

printf("#Split segments of %s\n",filename);
printf("#Generated using split_segments by %s, %s\n",getenv("USER"),date);

for n=1:rows(data) 

  number=data(n,1);
  start=data(n,2); 
  stop=data(n,3); 
  d=data(n,4); 
  
  if (d>max_duration) 
    
    count=1;
    while (start+max_duration < stop) 
      if (count<=nalphabet)
	label=sprintf("%d%c",number,alphabet(count)); 
      else
	label=sprintf("%d%c%c",number,alphabet(fix(count/nalphabet)),alphabet(1+rem(count-1,nalphabet))); 	  
      endif
      printf("%s %d %d %d\n",label,start,start+max_duration,max_duration);
      start+=max_duration-overlap+1; 
      count+=1;
    endwhile; 
    
    if (start < stop) 
      if (count<=nalphabet)
	label=sprintf("%d%c",number,alphabet(count)); 
      else
	label=sprintf("%d%c%c",number,alphabet(fix(count/nalphabet)),alphabet(rem(count,nalphabet))); 	  
      endif
      printf("%s %d %d %d\n",label,start,stop,stop-start); 
    endif
    
  else 
    label=sprintf("%d",number);
    printf("%s %d %d %d\n",label,start,stop,d); 
  endif
  
endfor
